@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Notifications')}}</h3>
                        </div>
                        <div class="card-body">


                            <div class="timeline timeline-inverse">
                                @forelse($notifications as $notification)
                                    <div>
                                        <i class="icon bg-gray"></i>
                                        <a href="{{ route('dashboard.notifications.view', [ 'notification' => $notification->id]) }}" class="timeline-item">
                                            <span class="time"><i class="far fa-clock"></i> {{ (new Carbon\Carbon($notification->created_at))->diffForHumans() }}</span>
                                            <h3 class="timeline-header border-0">{{ $notification->data['data'] }}</h3>
                                        </a>
                                    </div>
                                @empty
                                    <div>
                                        <i class="icon bg-gray"></i>
                                        <a class="timeline-item">
                                            <h3 class="timeline-header border-0">{{__("You haven't any new notifications")}}</h3>
                                        </a>
                                    </div>
                                @endforelse
                            </div>


                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
