@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" id="form" method="post" action="{{ route('dashboard.profile.update') }}">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Edit Profile')}}</h3>
                        </div>
                        <div class="card-body">

                            @csrf

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="username">{{__('Username')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="username" name="username" placeholder="{{__('Enter your username')}} ..." value="{{ $user->username }}" disabled />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="name">{{__('Name')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="{{__('Enter your name')}} ..." value="{{ old('name',$user->name) }}" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="email">{{__('Email')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="email" name="email" placeholder="{{__('Enter your email')}} ..." value="{{ old('email',$user->email) }}" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="location">{{__('Location')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="location" name="location" placeholder="{{__('Enter your location')}} ..." value="{{ old('location',$user->location) }}" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="job_title">{{__('Job Title')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" class="form-control" id="job_title" name="job_title" placeholder="{{__('Enter your job title')}} ..." value="{{ old('job_title',$user->job_title) }}" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="about">{{__('About')}}</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" id="about" name="about" placeholder="{{__('Write something about you')}} ...">{{ old('about',$user->about) }}</textarea>
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="avatar" class="col-sm-2 col-form-label">{{__('Profile picture')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" data-type="avatar" value="{{ old('about',$user->avatar) }}" class="form-control" id="avatar" name="avatar" disabled="">
                                    <i class="far fa-folder-open file_manger_icon"></i>
                                </div>
                            </div>

                            <hr />

                            <div class="form-group row">
                                <label class="col-sm-2 col-form-label" for="password">{{__('Password')}}</label>
                                <div class="col-sm-10">
                                    <input type="password" class="form-control" id="password" name="password" placeholder="{{__('Enter your password')}} ..." value="" />
                                </div>
                            </div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="update-profile" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Update')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
