@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-3">

                    <!-- Profile Image -->
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <img class="profile-user-img img-fluid img-circle" src="{{auth()->user()->avatar()}}" alt="{{ auth()->user()->name  }}" />
                            </div>

                            <h3 class="profile-username text-center">{{$user->name}}</h3>

                            <p class="text-muted text-center">{{$user->job_title}}</p>

                            <hr>

                            <strong><i class="fas fa-map-marker-alt mr-1"></i> {{__('Location')}}</strong>

                            <p class="text-muted">{{$user->location}}</p>

                            <hr>

                            <strong><i class="far fa-file-alt mr-1"></i> {{__('About')}}</strong>

                            <p class="text-muted">{{$user->about}}</p>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                </div>
                <!-- /.col -->
                <div class="col-md-9">

                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Recent Activities')}}</h3>
                        </div>
                        <div class="card-body">


                            <div class="timeline timeline-inverse">
                                @forelse($logs as $log)
                                    <div>
                                        <i class="icon bg-gray"></i>
                                        <div class="timeline-item">
                                            <span class="time"><i class="far fa-clock"></i> {{(new Carbon\Carbon($log->created_at))->diffForHumans()}} </span>
                                            <h3 class="timeline-header border-0">{{$log->body}}</h3>
                                        </div>
                                    </div>
                                @empty
                                    <div>
                                        <i class="icon bg-gray"></i>
                                        <div class="timeline-item">
                                            <h3 class="timeline-header border-0">{{__('You not have any activities')}}</h3>
                                        </div>
                                    </div>
                                @endforelse
                            </div>


                        </div>
                        <!-- /.card-body -->
                    </div>

                    <!-- /.nav-tabs-custom -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
@endsection
