@extends('dashboard.layout')

@section('content')


@php
$Date = date('Y-m-d',strtotime("-1 month"));

$Analytics = [];
$Analytics['new'] = [];
$Analytics['total'] = [];

$row = \DB::select("SELECT count(*) as Counter FROM `notifications_subscribers` WHERE DATE(`created_at`) > ? ",[$Date]);
$Analytics['new']['Created'] = $row[0]->Counter;

$row = \DB::select("
	SELECT count(*) as `Counter`
	FROM `notifications_subscribers`
	inner join `visitors` on `visitors`.`id` = `notifications_subscribers`.`visitor_id`
	WHERE
	DATE(`notifications_subscribers`.`last_seen`) > ?
	AND
	DATE(`notifications_subscribers`.`created_at`)  > ?
",[$Date,$Date]);
$Analytics['new']['LastSeen'] = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as Counter FROM `notifications_subscribers` WHERE DATE(`created_at`) > ? ",[$Date]);
$Analytics['total']['LastSeen'] = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as Counter FROM `notifications_sent` WHERE `status`='scheduled' AND DATE(`created_at`) > ? ",[$Date]);
$Analytics['new']['Scheduled'] = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as Counter FROM `notifications_sent` WHERE DATE(`created_at`) > ? ",[$Date]);
$Analytics['total']['Scheduled'] = $row[0]->Counter;

$Notification = \DB::select("
	SELECT
		SUM(`total_recipients`) as `total_recipients`,
		SUM(`success_recipients`) as `success_recipients`,
		SUM(`failure_recipients`) as `failure_recipients`
	FROM `notifications_sent`
	WHERE DATE(`created_at`) > ?
",[$Date]);
$Analytics['new']['Notifications']      = intval($Notification[0]->total_recipients);
$Analytics['new']['success_recipients'] = intval($Notification[0]->success_recipients);
$Analytics['new']['failure_recipients'] = intval($Notification[0]->failure_recipients);

$Notification = \DB::select("
	SELECT
		SUM(`total_recipients`) as `total_recipients`,
		SUM(`success_recipients`) as `success_recipients`,
		SUM(`failure_recipients`) as `failure_recipients`
	FROM
		`notifications_sent`
	WHERE DATE(`created_at`) > ?
",[$Date]);
$Analytics['total']['Notifications']      = intval($Notification[0]->total_recipients);
$Analytics['total']['success_recipients'] = intval($Notification[0]->success_recipients);
$Analytics['total']['failure_recipients'] = intval($Notification[0]->failure_recipients);
/*<!--------------------------------------------------------------------------------------
Start System -------------------------------------------------------------------------->*/
$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`browser`='Apple Safari' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Safari = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`browser`='Firefox' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$FireFox = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`browser`='Chrome' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Chrome = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`browser`='Opera' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Opera = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`browser`='Edge' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Edge = $row[0]->Counter;
/*<!--------------------------------------------------------------------------------------
Start System -------------------------------------------------------------------------->*/

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`platform` Like 'Windows%' and `visitors`.`platform`!='Windows Phone' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Windows = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`platform` Like 'linux%' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Linux = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`platform`='Macintosh' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Mac = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`platform`='Android' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$Android = $row[0]->Counter;

$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors` INNER Join `notifications_subscribers` on `visitors`.`id`=`notifications_subscribers`.`visitor_id` WHERE `visitors`.`platform`='IOS' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
$IOS = $row[0]->Counter;

@endphp
<section class="content">

    <div class="row">

        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">{{__('Push Notification')}}</h3>
                </div>
                <form class="card-body" id="pushNotifications" action="{{route('dashboard.push-notification.push')}}">

                    <div class="form-group">
                        <label>{{__('Notification to')}}</label>
                        <select class="form-control select2" name="notification_to" id="notification_to">
                            <option value="all_subscribers">{{__('All Subscribers')}}</option>
                            <option value="user">{{__('User')}}</option>
                        </select>
                    </div>

                    <div class="form-group" id="UserBox">
                        <label>{{__('User')}}</label>
                        <select class="form-control usersSerch" data-action='{{route('dashboard.users.list')}}' name="user" id="user">
                            <option value="all_users">{{__('All Users')}}</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>{{__('Notification Title')}}</label>
                        <input type="text" id="notification_title" class="form-control" placeholder="{{__('Enter Title')}}" />
                    </div>

                    <div class="form-group">
                        <label>{{__('Notification Body')}}</label>
                        <textarea id="notification_body" class="form-control" placeholder="{{__('Enter Body')}}"></textarea>
                    </div>

					<div class="form-group row">
                        <label class="col-md-12">{{__('Select image')}}:</label>
						<div class="col-md-12">
							<input type="text" data-type="image" value="" class="form-control" id="notification_image" name="image" disabled />
							<i class="far fa-folder-open file_manger_icon"></i>
						</div>
                    </div>

					<div class="form-group row">
                        <label class="col-md-12">{{__('Select icon')}}:</label>
						<div class="col-md-12">
							<input type="text" data-type="image" value="" class="form-control" id="notification_icon" name="image" disabled />
							<i class="far fa-folder-open file_manger_icon"></i>
						</div>
                    </div>

                    <div class="form-group">
                        <label>{{__('Notification Link')}}</label>
                        <input type="url" id="notification_click_action" class="form-control" placeholder="{{__('Enter Link')}}" />
                    </div>


                </form>

                <div class="card-footer text-right">
                    <button type="submit" id="Push" class="btn btn-primary">{{__('Push')}} <i class="fas fa-paper-plane"></i></button>
                </div>

            </div>
        </div>

        <div class="col-md-8">
			<div class="row">
				<div class="col-md-6">

		            <div class="info-box bg-yellow">
		                <span class="info-box-icon"><i class="fa fa-user-plus"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['new']['Created']}}</span>
		                    <span class="info-box-text">{{__('New Subscribers')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-red">
		                <span class="info-box-icon"><i class="fas fa-user-check"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['new']['LastSeen']}}</span>
		                    <span class="info-box-text">{{__('Active Subscribers')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-red">
		                <span class="info-box-icon"><i class="far fa-clock"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['new']['Scheduled']}}</span>
		                    <span class="info-box-text">{{__('Scheduled Notifications')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-teal">
		                <span class="info-box-icon"><i class="far fa-check-circle"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['total']['success_recipients']}}</span>
		                    <span class="info-box-text">{{__('Total Success Recipients')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-orange">
		                <span class="info-box-icon"><i class="fa fa-check"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['new']['success_recipients']}}</span>
		                    <span class="info-box-text">{{__('New Success Recipients')}}</span>
		                </div>
		            </div>

				</div>

				<div class="col-md-6">

		            <div class="info-box bg-blue">
		                <span class="info-box-icon"><i class="fa fa-users"></i></span>
		                <div class="info-box-content">
							<span class="info-box-number">{{$Analytics['total']['LastSeen']}}</span>
		                    <span class="info-box-text">{{__('Total Subscribers')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-olive">
		                <span class="info-box-icon"><i class="far fa-bell"></i></span>
		                <div class="info-box-content">
		                    <span class="info-box-number">{{$Analytics['total']['Notifications']}}</span>
							<span class="info-box-text">{{__('Total Pushed Notifications')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-maroon">
		                <span class="info-box-icon"><i class="fa fa-bell"></i></span>
		                <div class="info-box-content">
		                    <span class="info-box-number">{{$Analytics['new']['Notifications']}}</span>
							<span class="info-box-text">{{__('New Pushed Notifications')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-aqua">
		                <span class="info-box-icon"><i class="fa fa-exclamation-triangle"></i></span>
		                <div class="info-box-content">
		                    <span class="info-box-number">{{$Analytics['total']['failure_recipients']}}</span>
							<span class="info-box-text">{{__('Total Failure Recipients')}}</span>
		                </div>
		            </div>

		            <div class="info-box bg-light-blue">
		                <span class="info-box-icon"><i class="fa fa-user-times"></i></span>
		                <div class="info-box-content">
		                    <span class="info-box-number">{{$Analytics['new']['failure_recipients']}}</span>
							<span class="info-box-text">{{__('New Failure Recipients')}}</span>
		                </div>
		            </div>

				</div>
			</div>
			<form class="card card-primary card-outline" id="FCM_Form" action="{{ route('dashboard.push-notification.update-fcm-key') }}">
				<div class="card-header">
					<h3 class="card-title">{{__('FCM Key')}}</h3>
				</div>
				<div class="card-body" id="FCM_Key_Form">

					<div class="form-group">
						<label>{{__('FCM Key')}}</label>
						<input type="text" id="FCM_Key" value="{{ \Config::get('app.fcm.key') }}" class="form-control" placeholder="{{__('Enter your key')}}" />
					</div>

				</div>

				<div class="card-footer text-right">
					<button type="button" id="saveFCM_Key" class="btn btn-primary">{{__('Save')}} <i class="fas fa-wrench"></i></button>
				</div>

			</form>
		</div>

        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-header with-border">
                    <h3 class="card-title">{{__('browser Usage')}}</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="chart-responsive">
                                <canvas class="pieChart" id="PieData" data-obj="PieData" height="150"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card card-primary card-outline">
                <div class="card-header with-border">
                    <h3 class="card-title">{{__('OS Usage')}}</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="chart-responsive">
                                <canvas class="pieChart" id="PieData2" data-obj="PieData2" height="150"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">

            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">{{__('Subscribers')}} (Daily in Last 30 Days)</h3>
                </div>
                <div class="card-body">
                    <div id="chartdiv"></div>
                </div>
            </div>

        </div>

        <div class="col-md-12">

            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">{{__('Notifications Opened Rate')}} (Last 30 Days)</h3>
                </div>
                <div class="card-body">
                    <div id="chartdiv2"></div>
                </div>
            </div>

            <script src="https://www.amcharts.com/lib/3/amcharts.js"></script>
            <script src="https://www.amcharts.com/lib/3/serial.js"></script>
            <script src="https://www.amcharts.com/lib/3/plugins/export/export.min.js"></script>
            <link rel="stylesheet" href="https://www.amcharts.com/lib/3/plugins/export/export.css" type="text/css" media="all" />
            <script src="https://www.amcharts.com/lib/3/themes/patterns.js"></script>

            <script type="text/javascript">
                var PieData = {
			        labels: ['{{__('Chrome')}}', '{{__('FireFox')}}', '{{__('Safari')}}', '{{__('Opera')}}', '{{__('Edge')}}'],
			        datasets: [{
			            label: '',
			            data: [{{ $Chrome }},
						{{ $FireFox}},
						{{ $Safari }},
						{{ $Opera }},
						{{ $Edge }} ],
			            backgroundColor: [
							"#f56954",
                            "#f39c12",
                            "#00c0ef",
                            "#3c8dbc",
                            "#d2d6de"
			            ],
			            borderColor: [
			                'rgba(255, 99, 132, 1)',
			                'rgba(54, 162, 235, 1)',
			                'rgba(255, 206, 86, 1)',
			                'rgba(75, 192, 192, 1)',
			                'rgba(153, 102, 255, 1)',
			            ],
			            borderWidth: 1
			        }]
			    };

                $("#PieData").attr("data-obj",JSON.stringify(PieData));
                var PieData2 = {
					labels: [
                        "{{__('Windows')}}",
                        "{{__('Linux')}}",
                        "{{__('Mac')}}",
                        "{{__('Android')}}",
                        "{{__('IOS')}}"
                    ],
                    datasets: [{
                        data: [
                            {{ $Windows }},
                            {{ $Linux }},
                            {{ $Mac }},
                            {{ $Android }},
                            {{ $IOS }}
                        ],
                        backgroundColor: [
                            "#f56954",
                            "#00a65a",
                            "#f39c12",
                            "#00c0ef",
                            "#3c8dbc"
                        ],
                    }]
                };

                $("#PieData2").attr("data-obj",JSON.stringify(PieData2));

                var chart = AmCharts.makeChart("chartdiv", {
                    "type": "serial",
                    "theme": "patterns",
                    "marginRight": 40,
                    "marginLeft": 40,
                    "autoMarginOffset": 20,
                    "mouseWheelZoomEnabled":true,
                    "dataDateFormat": "YYYY-MM-DD",
                    "valueAxes": [{
                        "id": "v1",
                        "axisAlpha": 0,
                        "position": "left",
                        "ignoreAxisWidth":true
                    }],
                    "balloon": {
                        "borderThickness": 1,
                        "shadowAlpha": 0
                    },
                    "graphs": [{
                        "id": "g1",
                        "balloon":{
                            "drop":true,
                            "adjustBorderColor":false,
                            "color":"#ffffff"
                        },
                        "bullet": "round",
                        "bulletBorderAlpha": 1,
                        "bulletColor": "#FFFFFF",
                        "bulletSize": 5,
                        "hideBulletsCount": 50,
                        "lineThickness": 2,
                        "title": "red line",
                        "useLineColorForBulletBorder": true,
                        "valueField": "value",
                        "balloonText": "<span style='font-size:18px;'>[[value]]</span>"
                    }],
                    "chartScrollbar": {
                        "graph": "g1",
                        "oppositeAxis":false,
                        "offset":30,
                        "scrollbarHeight": 80,
                        "backgroundAlpha": 0,
                        "selectedBackgroundAlpha": 0.1,
                        "selectedBackgroundColor": "#888888",
                        "graphFillAlpha": 0,
                        "graphLineAlpha": 0.5,
                        "selectedGraphFillAlpha": 0,
                        "selectedGraphLineAlpha": 1,
                        "autoGridCount":true,
                        "color":"#AAAAAA"
                    },
                    "chartCursor": {
                        "pan": true,
                        "valueLineEnabled": true,
                        "valueLineBalloonEnabled": true,
                        "cursorAlpha":1,
                        "cursorColor":"#258cbb",
                        "limitToGraph":"g1",
                        "valueLineAlpha":0.2,
                        "valueZoomable":true
                    },
                    "valueScrollbar":{
                        "oppositeAxis":false,
                        "offset":50,
                        "scrollbarHeight":10
                    },
                    "categoryField": "date",
                    "categoryAxis": {
                        "gridPosition": "start",
                        "parseDates": true,
                        "groupToPeriods": 'ss',
                        "minPeriod": 'ss',
                        "maxSeries": 0,
                        "dashLength": 1,
                        "minorGridEnabled": true
                    },
                    "export": {
                        "enabled": true
                    },
                    "dataProvider": [
                    @php
						$rows = \DB::select("SELECT DATE(`created_at`) as date,count(*) as counter FROM `notifications_subscribers` WHERE  DATE(`created_at`) > ? group by DATE(`created_at`)  ",[$Date]);
						$i = 0;
						$len = count($rows);
						$last_date = "";
						foreach($rows as $row){
							if ($i == 0) {
								$date1=date_create($row->date);
							    $date2=date_create($Date);
							    $diff=date_diff($date1,$date2);
							 	$diff = $diff->format("%a");
								if($date1>$date2){
									for ($n=0; $n < $diff; $n++) {
										$thirtyDaysUnix = strtotime('+'.$n.' days', strtotime($Date));
										$thirtyDaysUnix = date("Y-m-d", $thirtyDaysUnix);
										@endphp
			                                {
			                                    "date": "{{$thirtyDaysUnix}}",
			                                    "value": 0
			                                },
			                            @php
									}
								}
							}else{
								$date1=date_create($row->date);
							    $date2=date_create($last_date);
							    $diff=date_diff($date1,$date2);
							 	$diff = $diff->format("%a");
								if($diff>1){
									for ($n=1; $n < $diff; $n++) {
										$thirtyDaysUnix = strtotime('+'.$n.' days', strtotime($last_date));
										$thirtyDaysUnix = date("Y-m-d", $thirtyDaysUnix);
										@endphp
			                                {
			                                    "date": "{{ $thirtyDaysUnix }}",
			                                    "value": 0
			                                },
			                            @php
									}
								}
							}
							@endphp
                                {
                                    "date": "{{ $row->date }}",
                                    "value": {{ $row->counter }}
                                },
                            @php
							if ($i == $len - 1) {
								$date1=date_create(date('Y-m-d'));
								$date2=date_create($row->date);
								$diff=date_diff($date1,$date2);
								$diff = $diff->format("%a");
								for ($n=1; $n < $diff+1; $n++) {
									$thirtyDaysUnix = strtotime('+'.$n.' days', strtotime($row->date));
									$thirtyDaysUnix = date("Y-m-d", $thirtyDaysUnix);
									@endphp
										{
											"date": "{{ $thirtyDaysUnix }}",
											"value": 0
										},
									@php
								}
							}
							$i++;
							$last_date = $row->date;
                        }
                    @endphp
                    ]
                });

                chart.addListener("rendered", zoomChart);

                zoomChart();

                function zoomChart() {
                    chart.zoomToIndexes(chart.dataProvider.length - 40, chart.dataProvider.length - 1);
                }

                var chart = AmCharts.makeChart("chartdiv2", {
                  "type": "serial",
                  "theme": "light",
                  "dataDateFormat": "YYYY-MM-DD JJ:NN:SS",
                  "precision": 0,
                  "valueAxes": [{
                    "id": "v1",
                    "title": "Notifications",
                    "position": "left",
                    "autoGridCount": false,
                    "labelFunction": function(value) {
                      return Math.round(value);
                    }
                  }, {
                    "id": "v2",
                    "title": "Pushed Notiftications",
                    "gridAlpha": 0,
                    "position": "right",
                    "autoGridCount": false
                  }],
                  "graphs": [{
                    "id": "g3",
                    "valueAxis": "v1",
                    "lineColor": "#e1ede9",
                    "fillColors": "#e1ede9",
                    "fillAlphas": 1,
                    "type": "column",
                    "title": "Pushed Notification",
                    "valueField": "PushedNotification",
                    "clustered": false,
                    "fixedColumnWidth": 15,
                    "legendValueText": "[[value]]",
                    "balloonText": "[[title]]<br /><b style='font-size: 130%'>[[value]] Notification</b>"
                  }, {
                    "id": "g4",
                    "valueAxis": "v1",
                    "lineColor": "#62cf73",
                    "fillColors": "#62cf73",
                    "fillAlphas": 1,
                    "type": "column",
                    "title": "Opened Notification",
                    "valueField": "OpenedNotification",
                    "clustered": false,
                    "fixedColumnWidth": 10,
                    "legendValueText": "[[value]]",
                    "balloonText": "[[title]]<br /><b style='font-size: 130%'>[[value]] Notification</b>"
                  }],
                  "chartScrollbar": {
                    "graph": "g1",
                    "oppositeAxis": false,
                    "offset": 30,
                    "scrollbarHeight": 50,
                    "backgroundAlpha": 0,
                    "selectedBackgroundAlpha": 0.1,
                    "selectedBackgroundColor": "#888888",
                    "graphFillAlpha": 0,
                    "graphLineAlpha": 0.5,
                    "selectedGraphFillAlpha": 0,
                    "selectedGraphLineAlpha": 1,
                    "autoGridCount": true,
                    "color": "#AAAAAA"
                  },
                  "chartCursor": {
                    "pan": true,
                    "valueLineEnabled": true,
                    "valueLineBalloonEnabled": true,
                    "cursorAlpha": 0,
                    "valueLineAlpha": 0.2
                  },
                  "categoryField": "date",
                  "categoryAxis": {
                    "minPeriod": 'ss',
                    "maxSeries": 0
                  },
                  "legend": {
                    "useGraphSettings": true,
                    "position": "top"
                  },
                  "balloon": {
                    "borderThickness": 1,
                    "shadowAlpha": 0
                  },
                  "export": {
                   "enabled": true
                  },
                  "dataProvider": [
                    	@php
                        $rows = \DB::select("Select * from `notifications_sent` WHERE DATE(`created_at`) > ? order by `id` desc limit 15 ",[$Date]);
                        $rows = array_reverse($rows);
						@endphp
						@foreach ($rows as $row)
                            {
                                "date": "{{ $row->created_at }}",
                                "PushedNotification": {{ intval($row->total_recipients) }} ,
                                "OpenedNotification": {{ intval($row->opened) }}
                            },
						@endforeach
                ]
                });
            </script>
            <style type="text/css">
                #chartdiv,
                #chartdiv2 {
                    width: 100%;
                    height: 500px;
                }
            </style>
        </div>

    </div>
</section>
@endsection
