@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Tickets')}}</h3>
                        </div>
                        <div class="card-body">

                            <table class="table table-striped table-bordered text-center datatable" data-system="tickets">
                                <thead>
                                <tr>
                                    <th>{{__('ID')}}</th>
                                    <th>{{__('Department')}}</th>
                                    <th>{{__('Subject')}}</th>
                                    <th>{{__('Status')}}</th>
                                    <th>{{__('Name')}}</th>
                                    <th class="project-actions">{{__('Actions')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @forelse($tickets ?? [] as $ticket)
                                        <tr>
                                            <td>{{$ticket->ticket_uuid}}</td>
											<td>
												@isset($ticket->department)
													{{$ticket->department['name_'.\Config::get('app.locale')]}}
												@endisset
											</td>
                                            <td>{{$ticket->title}}</td>
                                            <td>{{$ticket->status}}</td>
                                            <td>{{$ticket->user->name}}</td>
                                            <td>
                                                <a class="btn btn-primary btn-sm" href="{{route('dashboard.support.tickets.view', [ 'id' =>$ticket->id ] )}}">
                                                    <i class="fas fa-eye"></i>
                                                </a>
												@if(\Gate::check('delete-ticket') || \Gate::check('root-access') )
                                                <button class="btn btn-danger btn-sm delete_ticket" type="button" data-id="{{$ticket->id}}" data-toggle="modal" data-target="#delete_modal">
                                                    <i class="fas fa-trash"></i>
                                                </button>
												@endif

												@if(\Gate::check('close-ticket') || \Gate::check('root-access') )
                                                <button class="btn btn-danger btn-sm close_ticket" type="button" data-id="{{$ticket->id}}" data-toggle="modal" data-target="#close_modal">
                                                    <i class="fas fa-times"></i>
                                                </button>
												@endif


                                            </td>
                                        </tr>
                                    @empty
                                        <tr><td colspan="6">{{__('No Data')}}</td></tr>
                                    @endforelse
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td>{{__('Search By')}} {{__('ID')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Department')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Subject')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Status')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Name')}}</td>
                                    <td class="project-actions">
										@if(\Gate::check('new-ticket') || \Gate::check('root-access') )
	                                        <a class="btn btn-success btn-sm" href="{{route('dashboard.support.tickets.create' )}}">
	                                            <i class="fas fa-plus"></i>
	                                            {{__('Add New')}}
	                                        </a>
										@endif
                                    </td>
                                </tr>
                                </tfoot>
                            </table>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">

                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>


	<!-- Delete Modal -->
    <div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">{{__('Delete Ticket')}} "<span id="ticket_id"></span>"</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{__('Do You want to delete this ticket')}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                    <button type="button" class="btn btn-danger" id="delete_ticket" data-id="" data-dismiss="modal" data-url="{{route('dashboard.support.tickets.delete')}}">{{__('delete')}}</button>
                </div>
            </div>
        </div>
    </div>

	<!-- Close Modal -->
    <div class="modal fade" id="close_modal" tabindex="-1" role="dialog" aria-labelledby="closeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="closeModalLabel">{{__('close ticket')}} "<span id="close_ticket_id"></span>"</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{__('Do You want to close this ticket')}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('No')}}</button>
                    <button type="button" class="btn btn-danger" id="close_ticket" data-id="" data-dismiss="modal" data-url="{{route('dashboard.support.tickets.close')}}">{{__('Yes')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection
