@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{$ticket->title}}</h3>
                        </div>
                        <div class="card-body">

							<div class="direct-chat-messages">

								@foreach($ticket->messages as $message)

								    <!-- Message to the right -->
								    <div class="direct-chat-msg @if($message->created_by == $ticket->user_id) right @endif">

										@if($message->created_by == $ticket->user_id)
											<div class="direct-chat-infos clearfix">
									            <span class="direct-chat-name float-right">{{$message->user->name}}</span>
									            <span class="direct-chat-timestamp float-left">{{$message->created_at ? $message->created_at->diffForHumans(): 'No Time'}}</span>
									        </div>
										@else
											<div class="direct-chat-infos clearfix">
												<span class="direct-chat-timestamp float-right">{{$message->created_at ? $message->created_at->diffForHumans(): 'No Time'}}</span>
												<span class="direct-chat-name float-left">{{$message->user->name}}</span>
											</div>
										@endif

										<!-- /.direct-chat-infos -->
								        <img class="direct-chat-img" src="{{$message->user->avatar()}}" alt="{{$message->user->name}}" />
								        <!-- /.direct-chat-img -->
								        <div class="direct-chat-text">
											@if(!empty($message->note))
												<span class="float-right label label-danger">reported</span>
											@endif
								            {!!$message->message!!}
								        </div>
								        <!-- /.direct-chat-text -->
								    </div>
								    <!-- /.direct-chat-msg -->

								@endforeach

							</div>

							@if($ticket->status!='closed')

								<hr/>
								<form id="form" action="{{route('dashboard.support.tickets.reply')}}" method="post">
									<textarea class="form-control summernote" id="message" name="message" placeholder="{{__('Enter Content')}} ... "></textarea>
									<input hidden class="hidden" name="ticket_id" id="ticket_id" value="{{$ticket->ticket_uuid}}" />
									<div class="icheck-primary d-inline">
				                        <input type="checkbox" name="completed" id="completed">
				                        <label for="completed">
				                        	Mark as completed
				                        </label>
									</div>
								</form>

							@else
								<hr/>
								<label>User rate</label>
								<p>{{$ticket->notes}}</p>
								<div class="rating disabled " style="width: 20rem">

									<input id="rating-5" type="radio" name="rating" value="5" disabled @if($ticket->rate==5) checked @endif />
									<label for="rating-5"><i class="fas fa-3x fa-star"></i></label>

									<input id="rating-4" type="radio" name="rating" value="4" disabled @if($ticket->rate==4) checked @endif />
									<label for="rating-4"><i class="fas fa-3x fa-star"></i></label>

									<input id="rating-3" type="radio" name="rating" value="3" disabled @if($ticket->rate==3) checked @endif />
									<label for="rating-3"><i class="fas fa-3x fa-star"></i></label>

									<input id="rating-2" type="radio" name="rating" value="2" disabled @if($ticket->rate==2) checked @endif />
									<label for="rating-2"><i class="fas fa-3x fa-star"></i></label>

									<input id="rating-1" type="radio" name="rating" value="1" disabled @if($ticket->rate==1) checked @endif />
									<label for="rating-1"><i class="fas fa-3x fa-star"></i></label>

								</div>

							@endif

                        </div>

                        <!-- /.card-body -->
                        <div class="card-footer">

								<div class="d-block text-right">
									@if($ticket->status!='closed')
										<button type="button" id="sendTicketReply" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
									@endif
									<a class="btn btn-sm btn-info" href="{{route('dashboard.support.tickets')}}">Back</a>
								</div>

                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
