@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Forms')}}</h3>
                        </div>
                        <div class="card-body">

                            <table class="table table-striped table-bordered text-center datatable" data-system="systems">
                                <thead>
                                <tr>
                                    <th>{{__('ID')}}</th>
                                    <th>{{__('Title')}}</th>
                                    <th class="project-actions">{{__('Actions')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @forelse($forms as $row)
                                        <tr>
                                            <td>{{$row->id}}</td>
                                            <td>{{$row['name_'.\Config::get('app.locale')]}}</td>
                                            <td>
                                            	<a class="btn btn-info btn-sm" href="{{route('dashboard.tools.forms.list', [ 'form_id' =>$row->id ] )}}">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr><td colspan="3">{{__('No Data')}}</td></tr>
                                    @endforelse
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td>{{__('Search By')}} {{__('ID')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Title')}}</td>
                                    <td class="project-actions">
										@if(\Gate::check('new-form-builder') || \Gate::check('root-access') )
	                                        <a class="btn btn-success btn-sm" href="{{route('dashboard.developers.form-builder.create', [] )}}">
	                                            <i class="fas fa-plus"></i>
	                                            {{__('Add New')}}
	                                        </a>
										@endif
                                    </td>
                                </tr>
                                </tfoot>
                            </table>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">

                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>


    <!-- Delete Modal -->
    <div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">{{__('Delete Record')}} "<span id="record_id"></span>"</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{__('Do You want to delete this record')}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                    <button type="button" class="btn btn-danger" id="delete_record" data-id="" data-dismiss="modal" data-url="{{route('dashboard.developers.form-builder.delete', [ ] )}}">{{__('delete')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection
