<!DOCTYPE html>

<html lang="{{Config::get('app.locale')}}" dir="{{json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']}}" itemscope itemtype="http://schema.org/WebPage" prefix="og: http://ogp.me/ns#">

	<head @if(isset($Post) and !empty($Post)) typeof="og:article"@elsetypeof="og:website"@endif>

	    <meta charset="UTF-8" />

	    <!-- Mobile viewport optimized -->
	    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1" />
		<base href="{{url('')}}" />
		<meta name="home" content="{{route('frontend.index')}}" />

		<title>{{config('app.name')[config('app.locale')] }} | {{$title}}</title>

		<!-- SEO Specific Metas -->
        <meta name="robots" content="{{$meta['robots']}}" />
        <meta name="description" content="{{$meta['description']}}">
        <meta name="Author" content="Afrodien Panel">
		<meta name="keywords" content="{{$meta['keywords']}}">
		<!-- Schema.org markup for Google+ -->
        <meta itemprop="name" content="{{Config::get('app.name')[Config::get('app.locale')] }}" />
        <meta itemprop="description" content="{{$meta['description']}}" />
        <meta itemprop="image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Twitter Card data -->
        <meta name="twitter:card" content="summary_large_image" />
        <meta name="twitter:site" content="{{Config::get('app.social.twitter')}}" />
        <meta name="twitter:title" content="{{$meta['title']}}" />
        <meta name="twitter:description" content="{{$meta['description']}}" />
        <meta name="twitter:image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Open Graph data -->
        <meta property="fb:app_id" content="{{Config::get('app.social.facebook.app')}}" />
        @if(isset($Post) and !empty($Post))
        <meta property="og:type"   content="article" />
        @else
        <meta property="og:type"   content="website" />
        @endif
        <meta property="og:title" content="{{$meta['title']}}" />
        <meta property="og:image" content="{{$meta['featuredImage']['src']}}" />
        <meta property="og:image:type" content="{{$meta['featuredImage']['type']}}" />
        <meta property="og:image:width" content="{{$meta['featuredImage']['width']}}" />
        <meta property="og:image:height" content="{{$meta['featuredImage']['height']}}" />
        <meta property="og:description" content="{{$meta['description']}}" />
        <meta property="og:url" content="{{Config::get('app.default.url')}}" />
        <meta property="fb:pages" content="{{Config::get('app.social.facebook.page')}}">

        <!-- Site Map -->
        <link rel="sitemap" type="application/xml" title="Sitemap" href="{{route('sitemap.index')}}" />

        <!-- Setup Multi languages -->
		<link rel="alternate" href="{{Config::get('app.default.clean-url')}}" hreflang="x-default" />
        @foreach(Config::get('app.languages') as $language)
			<link rel="alternate" href="{{url($language->prefix."/".Config::get('app.default.clean-uri'))}}" hreflang="{{$language->prefix}}" />
        @endforeach

        <!-- Theme Color -->
        <meta name="theme-color" content="{{Config::get('app.default.color')}}" />
        <meta name="msapplication-navbutton-color" content="{{Config::get('app.default.color')}}" />

        <!-- iOS Safari -->
        <meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="{{Config::get('app.default.color')}}" />

        <!-- Canonical Tag -->
        <link rel="canonical" href="{{$meta['canonical']}}" />

        @if(isset($Post) and !empty($Post))
            @if(isset($Post['Prev']['URL']))<link rel="prev" href="{$Post.Prev.URL}" />@endif
            @if(isset($Post['Next']['URL']))<link rel="next" href="{$Post.Next.URL}" />@endif
        @endif

		<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">

        <script defer type="application/ld+json">{"@context": "http://schema.org","@type": "WebSite","url": "{{route('frontend.index')}}","potentialAction":{"@type": "SearchAction","target": "search/{search_term_string}","query-input":"required name=search_term_string"}}</script>
        <script defer type="application/ld+json">{"@context": "https://schema.org","@type": "Organization","url": "{{route('frontend.index')}}","logo": "{{url('/storage/'.config('app.logo.src'))}}","telephone": "{{config('app.contact.phone')}}","name": "{{config('app.name')[config('app.locale')]}}","legalName": "{{config('app.name')[config('app.locale')]}}","description": "{{config('app.description')[config('app.locale')]}}","sameAs": [ @if (!empty(Config::get('app.social.twitter'))) "https://twitter.com/{{Config::get('app.social.twitter')}}", @endif @if (!empty(Config::get('app.social.instagram'))) "https://www.instagram.com/{{Config::get('app.social.instagram')}}", @endif @if (!empty(Config::get('app.social.linkedin'))) "https://www.linkedin.com/in/{{Config::get('app.social.linkedin')}}", @endif @if (!empty(Config::get('app.social.facebook.page'))) "https://www.facebook.com/{{Config::get('app.social.facebook.page')}}" @endif ]}</script>

		<meta name="csrf-token" content="{{csrf_token()}}" />
		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
			<link
			  rel="stylesheet"
			  href="https://cdn.rtlcss.com/bootstrap/3.3.7/css/bootstrap.min.css"
			  integrity="sha384-cSfiDrYfMj9eYCidq//oGXEkMc0vuTxHXizrMOFAaPsLt1zoCUVnSsURN+nef1lj"
			  crossorigin="anonymous">
		@endif

		<link href="wp-content/themes/stchristwo/assets/css/main5ca2.css?1600878878" rel="stylesheet">
		<script type="text/javascript">
		window._wpemojiSettings = {"baseUrl":"https:\/\/s.w.org\/images\/core\/emoji\/2.3\/72x72\/","ext":".png","svgUrl":"https:\/\/s.w.org\/images\/core\/emoji\/2.3\/svg\/","svgExt":".svg","source":{"concatemoji":"https:\/\/dev1.everestad.com\/wp-includes\/js\/wp-emoji-release.min.js?ver=4.9.2"}};
		!function(a,b,c){function d(a,b){var c=String.fromCharCode;l.clearRect(0,0,k.width,k.height),l.fillText(c.apply(this,a),0,0);var d=k.toDataURL();l.clearRect(0,0,k.width,k.height),l.fillText(c.apply(this,b),0,0);var e=k.toDataURL();return d===e}function e(a){var b;if(!l||!l.fillText)return!1;switch(l.textBaseline="top",l.font="600 32px Arial",a){case"flag":return!(b=d([55356,56826,55356,56819],[55356,56826,8203,55356,56819]))&&(b=d([55356,57332,56128,56423,56128,56418,56128,56421,56128,56430,56128,56423,56128,56447],[55356,57332,8203,56128,56423,8203,56128,56418,8203,56128,56421,8203,56128,56430,8203,56128,56423,8203,56128,56447]),!b);case"emoji":return b=d([55358,56794,8205,9794,65039],[55358,56794,8203,9794,65039]),!b}return!1}function f(a){var c=b.createElement("script");c.src=a,c.defer=c.type="text/javascript",b.getElementsByTagName("head")[0].appendChild(c)}var g,h,i,j,k=b.createElement("canvas"),l=k.getContext&&k.getContext("2d");for(j=Array("flag","emoji"),c.supports={everything:!0,everythingExceptFlag:!0},i=0;i<j.length;i++)c.supports[j[i]]=e(j[i]),c.supports.everything=c.supports.everything&&c.supports[j[i]],"flag"!==j[i]&&(c.supports.everythingExceptFlag=c.supports.everythingExceptFlag&&c.supports[j[i]]);c.supports.everythingExceptFlag=c.supports.everythingExceptFlag&&!c.supports.flag,c.DOMReady=!1,c.readyCallback=function(){c.DOMReady=!0},c.supports.everything||(h=function(){c.readyCallback()},b.addEventListener?(b.addEventListener("DOMContentLoaded",h,!1),a.addEventListener("load",h,!1)):(a.attachEvent("onload",h),b.attachEvent("onreadystatechange",function(){"complete"===b.readyState&&c.readyCallback()})),g=c.source||{},g.concatemoji?f(g.concatemoji):g.wpemoji&&g.twemoji&&(f(g.twemoji),f(g.wpemoji)))}(window,document,window._wpemojiSettings);
		</script>
		<style type="text/css">
		img.wp-smiley,
		img.emoji {
		display: inline !important;
		border: none !important;
		box-shadow: none !important;
		height: 1em !important;
		width: 1em !important;
		margin: 0 .07em !important;
		vertical-align: -0.1em !important;
		background: none !important;
		padding: 0 !important;
		}
		</style>
		<link rel='stylesheet' id='ppm-google-calender-main-css'  href='wp-content/plugins/google-calender-to-wordpress/libs/fullcalendar/css/fullcalendar20fd.css?ver=4.9.2' type='text/css' media='all' />
		<link rel='stylesheet' id='ppm-google-calender-print-css'  href='wp-content/plugins/google-calender-to-wordpress/libs/fullcalendar/css/fullcalendar.print5152.css?ver=1.0' type='text/css' media='print' />
		<link rel='stylesheet' id='ppm-google-modal-main-css'  href='wp-content/plugins/google-calender-to-wordpress/libs/remodal/css/remodal20fd.css?ver=4.9.2' type='text/css' media='all' />
		<link rel='stylesheet' id='rs-plugin-settings-css'  href='wp-content/plugins/revslider/public/assets/css/settings9009.css?ver=5.4.5.1' type='text/css' media='all' />
		<style id='rs-plugin-settings-inline-css' type='text/css'>
		#rs-demo-id {}
		</style>
		<link rel='stylesheet' id='math-captcha-frontend-css'  href='wp-content/plugins/wp-math-captcha/css/frontend20fd.css?ver=4.9.2' type='text/css' media='all' />
		<link rel='stylesheet' id='js_composer_front-css'  href='wp-content/plugins/js_composer/assets/css/js_composer.min5fba.css?ver=5.2' type='text/css' media='all' />
		<script
		  src="https://code.jquery.com/jquery-3.5.1.min.js"
		  integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0="
		  crossorigin="anonymous"></script>

		<script type='text/javascript' src='wp-includes/js/jquery/jquery-migrate.min330a.js?ver=1.4.1'></script>
		<script type='text/javascript' src='wp-content/plugins/revslider/public/assets/js/jquery.themepunch.tools.min.js'></script>
		<script type='text/javascript' src='wp-content/plugins/revslider/public/assets/js/jquery.themepunch.revolution.min.js'></script>
		<script type="text/javascript">
		window._se_plugin_version = '8.1.9';
		</script>
		<script type="text/javascript">function setREVStartSize(e){
		try{ var i=jQuery(window).width(),t=9999,r=0,n=0,l=0,f=0,s=0,h=0;
			if(e.responsiveLevels&&(jQuery.each(e.responsiveLevels,function(e,f){f>i&&(t=r=f,l=e),i>f&&f>r&&(r=f,n=e)}),t>r&&(l=n)),f=e.gridheight[l]||e.gridheight[0]||e.gridheight,s=e.gridwidth[l]||e.gridwidth[0]||e.gridwidth,h=i/s,h=h>1?1:h,f=Math.round(h*f),"fullscreen"==e.sliderLayout){var u=(e.c.width(),jQuery(window).height());if(void 0!=e.fullScreenOffsetContainer){var c=e.fullScreenOffsetContainer.split(",");if (c) jQuery.each(c,function(e,i){u=jQuery(i).length>0?u-jQuery(i).outerHeight(!0):u}),e.fullScreenOffset.split("%").length>1&&void 0!=e.fullScreenOffset&&e.fullScreenOffset.length>0?u-=jQuery(window).height()*parseInt(e.fullScreenOffset,0)/100:void 0!=e.fullScreenOffset&&e.fullScreenOffset.length>0&&(u-=parseInt(e.fullScreenOffset,0))}f=u}else void 0!=e.minHeight&&f<e.minHeight&&(f=e.minHeight);e.c.closest(".rev_slider_wrapper").css({height:f})
		}catch(d){console.log("Failure at Presize of Slider:"+d)}
		};
		</script>
		<style type="text/css" data-type="vc_shortcodes-custom-css">.vc_custom_1501482287714{margin-top: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}.vc_custom_1510043565845{background-color: #d8d8d8 !important;}.vc_custom_1501496376170{margin-top: 25px !important;margin-bottom: 25px !important;}.vc_custom_1531375966461{margin-bottom: 90px !important;border-bottom-width: 90px !important;}.vc_custom_1501139360351{background-color: #bb1d3f !important;}.vc_custom_1531375229539{margin-top: -30px !important;}.vc_custom_1516525080255{background-color: #ffffff !important;}.vc_custom_1501742749087{background-color: #ffffff !important;}.vc_custom_1501406933082{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}.vc_custom_1500971494258{padding-top: 25px !important;padding-bottom: 25px !important;}.vc_custom_1500971508227{padding-top: 25px !important;padding-bottom: 25px !important;}.vc_custom_1500988091687{padding-top: 25px !important;padding-bottom: 25px !important;}.vc_custom_1501489257884{padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1506585048451{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1506594602158{padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1506594412834{margin-bottom: 0px !important;}.vc_custom_1503493203426{padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1511868875044{padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1512396479162{margin-top: 15px !important;margin-right: 15px !important;margin-left: 15px !important;padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-color: #ffffff !important;}.vc_custom_1512396487194{margin-top: 15px !important;margin-right: 15px !important;margin-left: 15px !important;padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-color: #ffffff !important;}.vc_custom_1512396496887{margin-top: 15px !important;margin-right: 15px !important;margin-left: 15px !important;padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;background-color: #ffffff !important;}.vc_custom_1566814916747{margin-bottom: 0px !important;padding-bottom: 0px !important;}.vc_custom_1566814696142{margin-bottom: 0px !important;padding-bottom: 25px !important;}.vc_custom_1566814979059{margin-bottom: 0px !important;}.vc_custom_1512375786494{margin-bottom: 0px !important;padding-bottom: 25px !important;}.vc_custom_1566815037639{margin-bottom: 0px !important;}.vc_custom_1512375635942{margin-bottom: 0px !important;padding-bottom: 25px !important;}.vc_custom_1503495187252{padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1512397849335{margin-top: 35px !important;margin-bottom: 35px !important;}.vc_custom_1503557192292{padding-top: 10px !important;padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1503557179971{padding-top: 10px !important;padding-right: 0px !important;padding-left: 0px !important;}.vc_custom_1513237267612{margin-bottom: 0px !important;}.vc_custom_1503557192292{padding-top: 10px !important;padding-right: 0px !important;padding-left: 0px !important;}</style>
		<noscript>
		<style type="text/css"> .wpb_animate_when_almost_visible { opacity: 1; }</style>
		</noscript>
		<link rel="stylesheet" type="text/css" href="wp-content/themes/stchristwo/assets/slick/slick.css"/>
		<link rel="stylesheet" type="text/css" href="wp-content/themes/stchristwo/assets/slick/slick-theme.css"/>
		<link href="//fonts.googleapis.com/css?family=Open+Sans:400%2C600|Roboto:100,300,400,500,700&subset=latin" rel="stylesheet">

		<script type="text/javascript">
			var languages = {!! json_encode(Config::get('app.languages')) !!};
		</script>


	    <link rel="apple-touch-icon-precomposed" href="{{url('/storage/'.config('app.logo.src'))}}" />
		<link rel="icon" sizes="192x192" href="{{url('/storage/'.config('app.logo.src'))}}">
		<link rel="shortcut icon" type="image/x-icon" href="{{url('/storage/'.config('app.favicon'))}}" />

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
			<link href="https://fonts.googleapis.com/css2?family=Almarai:wght@300&display=swap" rel="stylesheet">
			<link href="/css/rtl.css" rel="stylesheet">
		@endif


		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css" integrity="sha512-UTNP5BXLIptsaj5WdKFrkFov94lDx+eBvbKyoe1YAfjeRPC+gT5kyZ10kOHCfNZqEui1sxmqvodNUx3KbuYI/A==" crossorigin="anonymous" />
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" integrity="sha512-sMXtMNL1zRzolHYKEujM2AqCLUR9F2C4/05cdbxjjLSRvMQIciEPCQZo++nk7go3BtSuK9kfa/s+a4f4i5pLkw==" crossorigin="anonymous" />

		<!-- Include Auto ADS -->
		{!! Config::get('app.ad.auto') !!}

        <!-- Include Head Code -->
		{!! Config::get('app.head.html') !!}

		@yield('styles')

		<style>

		    .nav.navbar-nav.navbar-right > li.aaaa {
                border-left: none;
                background: #bb1d3f;
                color:#fff;
            }
            .nav.navbar-nav.navbar-right > li.aaaa a{
                color:#fff;
            }

		</style>


	</head>

	<body>
		<!-- Main Container -->
		<div class="container-fluid">

			<!-- Header -->
			@include('themes.MyLittleHouseSchool.inc.header')
			<!-- Header END -->

			<!-- Content -->
			<div class="container-fluid"></div>
			<!-- Content END -->

			<!-- Footer -->
			<footer></footer>
			<!-- Footer END -->

		</div>
		<!-- Main Container END -->

		@if(isset($page['slider']) && !empty($page['slider']))
			@include('themes.MyLittleHouseSchool.sliders.slider')
		@endif

		@yield('content')

		@include('themes.MyLittleHouseSchool.inc.footer')

		<script type="text/javascript" src="wp-content/themes/stchristwo/assets/slick/slick.min.js"></script>
		<script src="wp-content/themes/stchristwo/assets/js/bootstrap.min.js"></script>
		<script src="wp-content/themes/stchristwo/assets/js/jasny-bootstrap.min.js"></script>
		<script src="wp-content/themes/stchristwo/assets/js/webfontloader/webfontloader.js"></script>
		<script>
			WebFont.load({
				google: {
					families: ['Roboto:300,400,500,700:latin']
				}
			});
		</script>
		<script src="wp-content/themes/stchristwo/assets/js/custom6d27.js?1600878879"></script>
		<script type="text/javascript">
			function revslider_showDoubleJqueryError(sliderID) {
				var errorMessage = "Revolution Slider Error: You have some jquery.js library include that comes after the revolution files js include.";
				errorMessage += "<br> This includes make eliminates the revolution slider libraries, and make it not work.";
				errorMessage += "<br><br> To fix it you can:<br>&nbsp;&nbsp;&nbsp; 1. In the Slider Settings -> Troubleshooting set option:  <strong><b>Put JS Includes To Body</b></strong> option to true.";
				errorMessage += "<br>&nbsp;&nbsp;&nbsp; 2. Find the double jquery.js include and remove it.";
				errorMessage = "<span style='font-size:16px;color:#BC0C06;'>" + errorMessage + "</span>";
				jQuery(sliderID).show().html(errorMessage);
			}
		</script>

		<style type="text/css">
			.acf-map {
				width: 100%;
				height: 400px;
				border: #ccc solid 1px;
				margin: 20px 0;
			}
			/* fixes potential theme css conflict */
			.acf-map img {
				max-width: inherit !important;
			}
		</style>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js" integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw==" crossorigin="anonymous"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/venobox/1.9.1/venobox.min.js" integrity="sha512-6mm1Gra+9mSztlk6Q45F1soEHmkduyd2ponCIWNo5pr0lgcr8d79GQjQ3Nw0uRR3/+y/OZGklAi38yE1QSNpCw==" crossorigin="anonymous"></script>
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/venobox/1.9.1/venobox.min.css" integrity="sha512-e+0yqAgUQFoRrJ4pZigQXpOE0S7J9IGwmgH801h4H5ODqOCG8/GRfXHQ+9ab754NL79O7wDwdjwY3CcU8sEANg==" crossorigin="anonymous" />
		<script type="text/javascript">
			(function ($) {

				$(".video-icon").mouseenter(function () {
					$(this).find('img').attr('src', 'wp-content/uploads/2017/08/video-gray.png')
				});

				$(".video-icon").mouseleave(function () {
					$(this).find('img').attr('src', 'wp-content/uploads/2017/07/video.png')
				});

				$('.go-back').click(function (){
					if(history.length === 1){
						window.location = 'index.html'
					} else {
						history.back();
					}
				});

				$('.print-page').click(function (){
					window.print();
				});


$(".owl-carousel").owlCarousel({
	nav:true,
	loop:true,
	navigation : false,
	margin: 20,
	responsiveClass:true,
    responsive:{
        0:{
            items:1,
        },
        600:{
            items:3,
        },
        1000:{
            items:4,
        }
    }
});

$('.venobox').venobox();


})(jQuery);



		</script>

<style media="screen">
.owl-carousel.owl-drag .owl-item div{
width: 100%;
height: 100%;
max-height: 200px;
position: relative;
overflow: hidden;
background: -moz-linear-gradient(left, #29b2fe -20%, #443088 120%);
background: -webkit-linear-gradient(left, #29b2fe -20%, #443088 120%);
background: linear-gradient(to right, #29b2fe -20%, #443088 120%);
}

.owl-carousel .owl-item img {
    width: initial;
    height: initial;
    min-width:100%;
    min-height:100%;
	max-width: 100%;
}

.owl-item {
    height: 100%;
    display: block;
    height: 200px;
}
a.venobox.vbox-item {
    display: block;
}

.owl-item.active {
    height: auto;
}

.owl-prev {
    width: 40px;
    height: 40px;
    display: inline-block;
    text-align: center;
    line-height: 40px !important;
    background: #2f2f2f !important;
    color: #fff !important;
    top: 50%;
    position: absolute;
    transform: translateY(-50%);
	left: 0;
	font-size: 40px !important;
}

.owl-next {
    width: 40px;
    height: 40px;
    display: inline-block;
    text-align: center;
    line-height: 40px !important;
    background: #2f2f2f !important;
    color: #fff !important;
    top: 50%;
    position: absolute;
    transform: translateY(-50%);
	right: 0;
	font-size: 40px !important;
}
</style>

		@yield('script')
		@yield('scripts')

	</body>
</html>
