@extends('themes.MyLittleHouseSchool.app')

@section('content')


	<link href='../lib/main.css' rel='stylesheet' />
	<script src='../lib/main.js'></script>
	<script>

	  document.addEventListener('DOMContentLoaded', function() {
	    var calendarEl = document.getElementById('calendar');

	    var calendar = new FullCalendar.Calendar(calendarEl, {

	      headerToolbar: {
	        left: 'prev,next today',
	        center: 'title',
	        right: 'dayGridMonth,listYear'
	      },

	      displayEventTime: false, // don't show the time column in list view

	      // US Holidays
		  events: [
		    @foreach (\DB::table('calendar')->get() as $event)
		    {
				@if(config('app.locale')=='en')
			  	title : '{{$event->title_en}}',
				@else
				title : '{{$event->title_ar}}',
				@endif
			  	start : '{{$event->start_date}}',
			  	end   : '{{$event->end_date}}',
				url   : '{{$event->url}}'
		    },
			@endforeach
		],
	      eventClick: function(arg) {
	        // opens events in a popup window
	        window.open(arg.event.url, 'google-calendar-event', 'width=700,height=600');

	        arg.jsEvent.preventDefault() // don't navigate in main tab
	      },

	      loading: function(bool) {
	        document.getElementById('loading').style.display = bool ? 'block' : 'none';
	      }

	    });

	    calendar.render();
	  });
	</script>

<div class="main-container">
    <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">
        <div class="st-breadcrumb">
            <a href="/">{{__('Home')}}</a>
            <p class="slash">/</p>
            <a href="/{{$page->slug}}">{{$page->title}}</a>
        </div>
        <div class="white-container with-vc">
            <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 tablet-full" style="background: white; padding: 40px 0;">
                <div class="page-container">
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-12">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <h1 style="color: #444444;" class="vc_custom_heading">{{$page->title}}</h1>
									<br>
                                    <div class="wpb_text_column wpb_content_element letter-style-paragraph font-16">
                                        <div class="wpb_wrapper">
                                            {!! $page->content !!}

											<div id='loading'>loading...</div>

											<div id='calendar'></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
  #loading {
    display: none;
    position: absolute;
    top: 10px;
    right: 10px;
  }

  #calendar {
    max-width: 1100px;
    margin: 0 auto;
  }

</style>

@endsection
