@extends('themes.MyLittleHouseSchool.app')

@section('content')
	<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>

<div class="main-container" id="page" data-slug="{{$page->slug}}">
    <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">
        <div class="st-breadcrumb">
            <a href="/">{{__('Home')}}</a>
            <p class="slash">/</p>
            <a href="/{{$page->slug}}">{{$page->title}}</a>
        </div>
        <div class="white-container with-vc">
            <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 tablet-full" style="background: white; padding: 40px 0;">
                <div class="page-container">
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-12">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <h1 style="color: #444444;" class="vc_custom_heading">{{$page->title}}</h1>
									<br>
									<!-- div class="wpb_single_image wpb_content_element vc_align_left full-responsive-img">
                                        <figure class="wpb_wrapper vc_figure">
                                            <div class="vc_single_image-wrapper vc_box_border_grey">
                                                <img
                                                    width="{{$page->featuredImage['width']}}"
                                                    height="{{$page->featuredImage['height']}}"
                                                    src="{{$page->featuredImage['src']}}"
                                                    class="vc_single_image-img attachment-full"
                                                />
                                            </div>
                                        </figure>
                                    </div>
									<br -->
                                    <div class="wpb_text_column wpb_content_element letter-style-paragraph font-16">
                                        <div class="wpb_wrapper">
                                            {!! $page->content !!}
											<br>

											<style media="screen">

span.select2.select2-container.select2-container--default.select2-container--above ,
span.select2.select2-container.select2-container--default{
width: 100% !important;
}
											</style>

											<div class="row">
												<div class="col-md-6">
													<label for="">Choose a Track</label>
													<div class="">
														<select class="select2 form-control" id="path" name="">
															<option value="National">{{__('National')}}</option>
															<option value="International">{{__('International')}}</option>
														</select>
													</div>
												</div>

												<div class="col-md-6">
													<label for="">Choose Grade</label>

													<div class="path" id="National">
														<select class="select2 form-control" name="">
															<option>Choose Grade</option>
															<option value="Preschool">Preschool</option>
															<option value="KG-1">KG 1</option>
															<option value="KG-2">KG 2</option>
															<option value="Elementary-Grade-1">Elementary Grade 1</option>
															<option value="Elementary-Grade-2">Elementary Grade 2</option>
															<option value="Elementary-Grade-3">Elementary Grade 3</option>
															<option value="Elementary-Grade-4">Elementary Grade 4</option>
															<option value="Elementary-Grade-5">Elementary Grade 5</option>
															<option value="Elementary-Grade-6">Elementary Grade 6</option>
															<option value="Intermediate-Grade-1">Intermediate Grade 1</option>
															<option value="Intermediate-Grade-2">Intermediate Grade 2</option>
															<option value="Intermediate-Grade-3">Intermediate Grade 3</option>
															<option value="Secondary-1">Secondary 1</option>
															<option value="Secondary-2">Secondary 2</option>
															<option value="Secondary-3">Secondary 3</option>
														</select>
													</div>

													<div class="path" id="International" style="display:none;">
														<select class="select2 form-control" name="">
															<option>Choose Grade</option>
															<option value="KG-2">KG 2</option>
															<option value="KG-3">KG 3</option>
															<option value="Elementary-Grade-1">Elementary Grade 1</option>
															<option value="Elementary-Grade-2">Elementary Grade 2</option>
															<option value="Elementary-Grade-3">Elementary Grade 3</option>
															<option value="Elementary-Grade-4">Elementary Grade 4</option>
															<option value="Elementary-Grade-5">Elementary Grade 5</option>
															<option value="Elementary-Grade-6">Elementary Grade 6</option>
															<option value="Intermediate-Grade-7">Intermediate Grade 7</option>
															<option value="Intermediate-Grade-8">Intermediate Grade 8</option>
															<option value="Intermediate-Grade-9">Intermediate Grade 9</option>
															<option value="Secondary-10">Secondary IGCSE A/AS Grade 10</option>
															<option value="Secondary-11">Secondary IGCSE A/AS Grade 11</option>
															<option value="Secondary-12">Secondary IGCSE A/AS Grade 12</option>
														</select>
													</div>

												</div>
											</div>


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
	<script type="text/javascript">
		$('.select2').select2();
		$('#path').on('change', function(){
			$('.path').hide();
			$("#"+$(this).val()).show();
		});
		$('.path select').on('change', function(){
			var Slug  = $("#page").data('slug');
			var Track = $("#path").val();
			var Grade = $(this).val();
			window.open("{{route('frontend.download-files')}}?slug="+Slug+"&track="+Track+"&grade="+Grade,'_blank');
		});
	</script>
@endsection
