@extends('themes.MyLittleHouseSchool.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$page->title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
				<div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
				</div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Login - Register Section ===== -->
	<section id="login">
	    <div class="container">
	        <div class="row">
		        <div class="col-md-6 offset-md-3 col-md-offset-3 col-xs-12">

		            <!-- Start of Login Box -->
		            <div class="login-box">

		                <!-- Start of Login Form -->
		                <form action="{{route('login')}}" method="post">

							@csrf

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <label>{{__('Email')}}</label>
		                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}" placeholder="{{__('Your Email')}}" required autocomplete="email" autofocus />
								@error('email')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <label>{{__('Password')}}</label>
		                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="{{__('Your Password')}}" required autocomplete="current-password" />
								@error('password')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
		                    </div>

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <div class="row">
		                            <div class="col-6 text-as-lang">
		                                <input id="remember-me2" type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }} />
		                                <label for="remember-me2">{{__('Remember me?')}}</label>
		                            </div>
									<div class="col-6 text-not-as-lang">
				                        <button class="btn btn-success btn-effect" type="submit" name="login">{{__('login')}}</button>
				                    </div>
		                        </div>
		                    </div>

							@if (session('message'))
								<div class="alert alert-danger">{{ session('message') }}</div>
							@endif

							<div class="text-as-lang">
								<a href="{{ route('password.request')}}">- {{__('Forgot password?')}}</a>
							</div>

							<div class="fb-login-button" data-size="large" data-button-type="login_with" data-layout="default" data-auto-logout-link="false" data-use-continue-as="true" data-width=""></div>	                </form>
		                <!-- End of Login Form -->
		            </div>
		            <!-- End of Login Box -->

		        </div>
	        </div>
	    </div>
	</section>
	<!-- ===== End of Login - Register Section ===== -->
@endsection
