<!DOCTYPE html>

<html lang="{{Config::get('app.locale')}}" dir="{{json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']}}" itemscope itemtype="http://schema.org/WebPage" prefix="og: http://ogp.me/ns#">

	<head @if(isset($Post) and !empty($Post)) typeof="og:article"@elsetypeof="og:website"@endif>

	    <meta charset="UTF-8" />

	    <!-- Mobile viewport optimized -->
	    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1" />
		<base href="{{url('')}}" />
		<meta name="home" content="{{route('frontend.index')}}" />

		<title>{{config('app.name')[config('app.locale')] }} | {{$title}}</title>

		<!-- SEO Specific Metas -->
        <meta name="robots" content="{{$meta['robots']}}" />
        <meta name="description" content="{{$meta['description']}}">
        <meta name="Author" content="Afrodien Panel">
		<meta name="keywords" content="{{$meta['keywords']}}">
		<!-- Schema.org markup for Google+ -->
        <meta itemprop="name" content="{{Config::get('app.name')[Config::get('app.locale')] }}" />
        <meta itemprop="description" content="{{$meta['description']}}" />
        <meta itemprop="image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Twitter Card data -->
        <meta name="twitter:card" content="summary_large_image" />
        <meta name="twitter:site" content="{{Config::get('app.social.twitter')}}" />
        <meta name="twitter:title" content="{{$meta['title']}}" />
        <meta name="twitter:description" content="{{$meta['description']}}" />
        <meta name="twitter:image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Open Graph data -->
        <meta property="fb:app_id" content="{{Config::get('app.social.facebook.app')}}" />
        @if(isset($Post) and !empty($Post))
        <meta property="og:type"   content="article" />
        @else
        <meta property="og:type"   content="website" />
        @endif
        <meta property="og:title" content="{{$meta['title']}}" />
        <meta property="og:image" content="{{$meta['featuredImage']['src']}}" />
        <meta property="og:image:type" content="{{$meta['featuredImage']['type']}}" />
        <meta property="og:image:width" content="{{$meta['featuredImage']['width']}}" />
        <meta property="og:image:height" content="{{$meta['featuredImage']['height']}}" />
        <meta property="og:description" content="{{$meta['description']}}" />
        <meta property="og:url" content="{{Config::get('app.default.url')}}" />
        <meta property="fb:pages" content="{{Config::get('app.social.facebook.page')}}">

        <!-- Site Map -->
        <link rel="sitemap" type="application/xml" title="Sitemap" href="{{route('sitemap.index')}}" />

        <!-- Setup Multi languages -->
		<link rel="alternate" href="{{Config::get('app.default.clean-url')}}" hreflang="x-default" />
        @foreach(Config::get('app.languages') as $language)
			<link rel="alternate" href="{{url($language->prefix."/".Config::get('app.default.clean-uri'))}}" hreflang="{{$language->prefix}}" />
        @endforeach

        <!-- Theme Color -->
        <meta name="theme-color" content="{{Config::get('app.default.color')}}" />
        <meta name="msapplication-navbutton-color" content="{{Config::get('app.default.color')}}" />

        <!-- iOS Safari -->
        <meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="{{Config::get('app.default.color')}}" />

        <!-- Canonical Tag -->
        <link rel="canonical" href="{{$meta['canonical']}}" />

        @if(isset($Post) and !empty($Post))
            @if(isset($Post['Prev']['URL']))<link rel="prev" href="{$Post.Prev.URL}" />@endif
            @if(isset($Post['Next']['URL']))<link rel="next" href="{$Post.Next.URL}" />@endif
        @endif

        <script defer type="application/ld+json">{"@context": "http://schema.org","@type": "WebSite","url": "{{route('frontend.index')}}","potentialAction":{"@type": "SearchAction","target": "search/{search_term_string}","query-input":"required name=search_term_string"}}</script>
        <script defer type="application/ld+json">{"@context": "https://schema.org","@type": "Organization","url": "{{route('frontend.index')}}","logo": "{{url('/storage/'.config('app.logo.src'))}}","telephone": "{{config('app.contact.phone')}}","name": "{{config('app.name')[config('app.locale')]}}","legalName": "{{config('app.name')[config('app.locale')]}}","description": "{{config('app.description')[config('app.locale')]}}","sameAs": [ @if (!empty(Config::get('app.social.twitter'))) "https://twitter.com/{{Config::get('app.social.twitter')}}", @endif @if (!empty(Config::get('app.social.instagram'))) "https://www.instagram.com/{{Config::get('app.social.instagram')}}", @endif @if (!empty(Config::get('app.social.linkedin'))) "https://www.linkedin.com/in/{{Config::get('app.social.linkedin')}}", @endif @if (!empty(Config::get('app.social.facebook.page'))) "https://www.facebook.com/{{Config::get('app.social.facebook.page')}}" @endif ]}</script>

		<meta name="csrf-token" content="{{csrf_token()}}" />


	    <!-- CSS links -->
		<link rel="preload" as="style" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" integrity="sha512-1PKOgIY59xJ8Co8+NE6FZ+LOAZKjy+KY8iq0G4B3CyeY6wYHN3yt9PW0XpSriVlkMXe40PTKnXrLnZ9+fkDaog==" crossorigin="anonymous" onload="this.rel='stylesheet'" />

		<link rel="preconnect" href="https://www.gstatic.com" />
		<link rel="preconnect" href="https://www.google-analytics.com" />
		<link rel="preconnect" href="https://firebaseinstallations.googleapis.com" />
		<link rel="preconnect" href="https://fcmregistrations.googleapis.com" />
		<link rel="preconnect" href="https://code.jquery.com" />
		<link rel="preconnect" href="https://cdn.jsdelivr.net" />
		<link rel="preconnect" href="https://stackpath.bootstrapcdn.com" />
		<link rel="preconnect" href="https://fonts.googleapis.com/" />
		<link rel="preconnect" href="https://cdnjs.cloudflare.com/" />

		<link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Almarai&display=swap" onload="this.rel='stylesheet'">

		<!-- CSS only -->
		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="ltr")
			<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" integrity="sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z" crossorigin="anonymous">
			@yield('styles')
			<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/style.css')}}" />
        @else
			<link rel="stylesheet" href="https://cdn.rtlcss.com/bootstrap/v4.2.1/css/bootstrap.min.css" integrity="sha384-vus3nQHTD+5mpDiZ4rkEPlnkcyTP+49BhJ4wJeJunw06ZAp+wzzeBPUXr42fi8If" crossorigin="anonymous">
			@yield('styles')
			<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/style.css')}}" />
			<link rel="stylesheet" type="text/css" href="{{asset('assets/css/style-rtl.css')}}" />
        @endif


		<script type="text/javascript">
			var languages = {!! json_encode(Config::get('app.languages')) !!};
		</script>


	    <link rel="apple-touch-icon-precomposed" href="{{url('/storage/'.config('app.logo.icon'))}}" />
		<link rel="icon" sizes="192x192" href="{{url('/storage/'.config('app.logo.icon'))}}">
		<link rel="shortcut icon" type="image/x-icon" href="{{url('/storage/'.config('app.favicon'))}}" />



	    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
	    <!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->

        <!-- Include Auto ADS -->
		{!! Config::get('app.ad.auto') !!}

        <!-- Include Head Code -->
		{!! Config::get('app.head.html') !!}



	</head>

	<body>

		@include('themes.alnakhlawy.inc.header')

		@if(isset($page['slider']) && !empty($page['slider']))
			@include('themes.alnakhlawy.sliders.slider')
        @endif

		@yield('content')

		@include('themes.alnakhlawy.inc.footer')

	    <a href="#" class="back-top">
			<i class="fa fa-chevron-up"></i>
		</a>

		@if(Auth::check())
			<form id="logout-form" action="{{route('logout')}}" method="POST" style="display: none;">
				@csrf
			</form>
		@endif

		<!-- ===== All Javascript at the bottom of the page for faster page loading ===== -->

		<!-- JS, Popper.js, and jQuery -->
		<script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
			<script src="https://cdn.rtlcss.com/bootstrap/v4.2.1/js/bootstrap.min.js" integrity="sha384-a9xOd0rz8w0J8zqj1qJic7GPFfyMfoiuDjC9rqXlVOcGO/dmRqzMn34gZYDTel8k" crossorigin="anonymous"></script>
		@else
			<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js" integrity="sha384-B4gt1jrGC7Jh4AgTPSdUtOBvfO8shuf57BaghqFfPlYxofvL8/KUEfYiJOMMV+rV" crossorigin="anonymous"></script>
		@endif

		@yield('scripts')


		<!-- Firebase App (the core Firebase SDK) is always required and must be listed first -->
	    <script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-app.js"></script>

		<!-- Firebase messaging -->
	    <script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-messaging.js"></script>

		<script src="https://cdnjs.cloudflare.com/ajax/libs/lazysizes/5.2.2/lazysizes.min.js" integrity="sha512-TmDwFLhg3UA4ZG0Eb4MIyT1O1Mb+Oww5kFG0uHqXsdbyZz9DcvYQhKpGgNkamAI6h2lGGZq2X8ftOJvF/XjTUg==" crossorigin="anonymous"></script>

		<!-- Afrodien App JS -->
		<script defer src="{{asset('plugins/afrodien/js/app.js')}}"></script>

		<script defer src="{{asset('assets/js/custom.js')}}"></script>

        {!! Config::get('app.body.html') !!}

    </body>

</html>
