<footer>

	<!-- ===== Start of Footer Information & Links Section ===== -->
	<div class="footer-info">
		<div class="container">
			<div class="row">

				<!-- 1st Footer Column -->
				<div class="col-md-4 footer-about">

					<!-- Your Logo Here -->
					<a href="/" title="{{__('home')}}" class="footer-logo">
						{{ Config::get('app.name')[Config::get('app.locale')] }}
					</a>

					<!-- Small Description -->
					<p>{{ Config::get('app.description')[Config::get('app.locale')] }}</p>

					<!-- Info -->
					<ul class="footer-contact-info">
						<li><i class="fas fa-phone-alt"></i><a title="{{__('Phone')}}" href="tel:{{ Config::get('app.contact.phone') }}">{{ Config::get('app.contact.phone') }}</a></li>
						<li><i class="fas fa-at"></i><a title="{{__('Email')}}" href="mailto:{{ Config::get('app.contact.credential.email') }}">{{ Config::get('app.contact.credential.email') }}</a></li>
					</ul>
				</div>

				<!-- 2nd Footer Column -->

				<!-- 3rd Footer Column -->
				<div class="col-md-4 footer-posts">
					<h3>{{__('Popular Posts')}}</h3>
					@foreach($popularPosts ?? [] as $post)
					<div class="footer-blog-post">
						<div class="thumbnail-post">
							<a href="{{$post->url}}" title="{{$post->title}}">
								<img src="{{asset('/storage/loading.webp')}}" data-src="{{$post->thumbnail(100)['src']}}" class="lazyload" alt="{{$post->title}}" />
							</a>
						</div>
						<div class="post-info">
							<a href="{{$post->url}}" title="{{$post->title}}">{{$post->title}}</a>
							<p>{{$post->description}}</p>
						</div>
					</div>
					@endforeach
				</div>

				<div class="col-md-4 footer-links">
					<h3>{{__('Useful Links')}}</h3>

					<!-- Links -->
					<ul>
						<li><a href="{{route('frontend.blog')}}" title="{{__('blog')}}"><i class="fa fa-angle-double-right"></i>{{__('blog')}}</a></li>
						<li><a href="{{route('frontend.page',['page_slug'=>'faqs'])}}" title="{{__('FAQ')}}"><i class="fa fa-angle-double-right"></i>{{__('FAQ')}}</a></li>
						<li><a href="{{route('frontend.page',['page_slug'=>'login'])}}" title="{{__('login')}}"><i class="fa fa-angle-double-right"></i>{{__('login')}}</a></li>
						<li><a href="{{route('frontend.page',['page_slug'=>'privacy-policy'])}}" title="{{__('privacy policy')}}"><i class="fa fa-angle-double-right"></i>{{__('privacy policy')}}</a></li>
						<li><a href="{{route('frontend.page',['page_slug'=>'terms-and-conditions'])}}" title="{{__('Terms & Conditions')}}"><i class="fa fa-angle-double-right"></i>{{__('Terms & Conditions')}}</a></li>
						<li><a href="{{route('frontend.page',['page_slug'=>'register'])}}" title="{{__('register')}}"><i class="fa fa-angle-double-right"></i>{{__('register')}}</a></li>
						<li><a href="{{route('frontend.store')}}"><i class="fa fa-angle-double-right" title="{{__('Store')}}"></i>{{__('Store')}}</a></li>
					</ul>
				</div>


			</div>
		</div>
	</div>
	<!-- ===== End of Footer Information & Links Section ===== -->


	<!-- ===== Start of Footer Copyright Section ===== -->
	<div class="copyright">
		<div class="container">
			<div class="row">

				<div class="col-md-8 col-sm-12">
					<span>{{ Config::get('app.copyright')[Config::get('app.locale')] }}</span>
				</div>

				<div class="col-md-4 col-sm-12">
					<!-- Start of Social Media Buttons -->
					<ul class="social-btns">

						@if (!empty(Config::get('app.social.facebook.page')))
							<!-- Social Media -->
							<li>
								<a href="https://www.facebook.com/{{ Config::get('app.social.facebook.page') }}" title="facebook" class="social-btn-roll facebook">
									<div class="social-btn-roll-icons">
										<i class="social-btn-roll-icon fab fa-facebook-f"></i>
										<i class="social-btn-roll-icon fab fa-facebook-f"></i>
									</div>
								</a>
							</li>
						@endif

						@if (!empty(Config::get('app.social.twitter')))
							<!-- Social Media -->
							<li>
								<a href="https://twitter.com/{{ Config::get('app.social.twitter') }}" title="twitter" class="social-btn-roll twitter">
									<div class="social-btn-roll-icons">
										<i class="social-btn-roll-icon fab fa-twitter"></i>
										<i class="social-btn-roll-icon fab fa-twitter"></i>
									</div>
								</a>
							</li>
						@endif

						@if (!empty(Config::get('app.social.instagram')))
							<!-- Social Media -->
							<li>
								<a href="https://www.instagram.com/{{ Config::get('app.social.instagram') }}" title="instagram" class="social-btn-roll instagram">
									<div class="social-btn-roll-icons">
										<i class="social-btn-roll-icon fab fa-instagram"></i>
										<i class="social-btn-roll-icon fab fa-instagram"></i>
									</div>
								</a>
							</li>
						@endif

						@if (!empty(Config::get('app.social.linkedin')))
							<!-- Social Media -->
							<li>
								<a href="https://www.linkedin.com/in/{{ Config::get('app.social.linkedin') }}" title="linkedin" class="social-btn-roll linkedin">
									<div class="social-btn-roll-icons">
										<i class="social-btn-roll-icon fab fa-linkedin-in"></i>
										<i class="social-btn-roll-icon fab fa-linkedin-in"></i>
									</div>
								</a>
							</li>
						@endif

					</ul>
					<!-- End of Social Media Buttons -->
				</div>

			</div>
		</div>
	</div>
	<!-- ===== End of Footer Copyright Section ===== -->

</footer>
<!-- =============== End of Footer 1 =============== -->
