@extends('themes.alnakhlawy.app')

@section('content')
<!-- ===== Start of Candidate Profile Header Section ===== -->
<section class="profile-header bg-image" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');"></section>
<!-- ===== End of Candidate Header Section ===== -->

<!-- ===== Start of Main Wrapper Candidate Profile Section ===== -->
<section id="candidate-profile">
    <div class="container">

        <!-- Start of Row -->
        <div class="row candidate-profile">

            <!-- Start of Profile Picture -->
            <div class="col-md-3 col-xs-12 text-center">
                <div class="profile-photo">
					<a href="{{asset('storage/users/user-1.jpg')}}" class="hover-zoom venobox">
	                    <img src="{{asset('storage/users/user-1.jpg')}}" class="img-responsive" alt="Mohamed Nakhlawy" />
					</a>
				</div>

                <!-- Start of Social Media Buttons -->
                <ul class="social-btns">
                    <!-- Social Media -->
                    <li>
                        <a href="https://www.facebook.com/{{ Config::get('app.social.facebook.page') }}" class="social-btn-roll facebook transparent">
                            <div class="social-btn-roll-icons">
                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
                            </div>
                        </a>
                    </li>

                    <!-- Social Media -->
                    <li>
                        <a href="https://twitter.com/{{ Config::get('app.social.twitter') }}" class="social-btn-roll twitter transparent">
                            <div class="social-btn-roll-icons">
                                <i class="social-btn-roll-icon fab fa-twitter"></i>
                                <i class="social-btn-roll-icon fab fa-twitter"></i>
                            </div>
                        </a>
                    </li>

                    <!-- Social Media -->
                    <li>
                        <a href="https://www.linkedin.com/in/{{ Config::get('app.social.linkedin') }}" class="social-btn-roll linkedin transparent">
                            <div class="social-btn-roll-icons">
                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
                            </div>
                        </a>
                    </li>

                </ul>
                <!-- End of Social Media Buttons -->

            </div>
            <!-- End of Profile Picture -->

            <!-- Start of Profile Description -->
            <div class="col-md-9 col-xs-12">
                <div class="profile-descr">

                    <!-- Profile Title -->
                    <div class="profile-title">
                        <h2 class="capitalize">{{__('Mohamed Nakhlawy')}}</h2>
                        <h5>{{__('Full Stack Developer')}}</h5>
                    </div>

                    <!-- Profile Details -->
                    <div class="profile-details">
						{!! $page['content'] !!}
                    </div>

                    <ul class="profile-info">
                        <li>
                            <i class="fas fa-map-marker"></i>
                            <span>{{__('Asharqia')}}, {{__('Egypt')}}</span>
                        </li>

                        <li>
                            <i class="fas fa-globe"></i>
                            <a href="https://alnakhlawy.com">alnakhlawy.com</a>
                        </li>

                        <li>
                            <i class="fas fa-dollar-sign"></i>
                            <span>$10 / {{__('hour')}}</span>
                        </li>

                        <li>
                            <i class="fas fa-birthday-cake"></i>
                            <span>24 {{__('years-old')}}</span>
                        </li>

                        <li>
                            <i class="fas fa-phone-alt"></i>
                            <a href="tel:+201067776506">(+2) 01067776506</a>
                        </li>

                        <li>
                            <i class="fas fa-envelope"></i>
                            <a href="mailto:mohamed@alnakhlawy.com">mohamed@alnakhlawy.com</a>
                        </li>
                    </ul>

                </div>
            </div>
            <!-- End of Profile Description -->

        </div>
        <!-- End of Row -->


    </div>
</section>
<!-- ===== End of Candidate Profile Section ===== -->





    @include('themes.alnakhlawy.sections.portfolio')






<!-- ===== Start of Education Section ===== -->
<section class="education">
    <div class="container">

		<div class="section-title">
			<h2 class="text-center">{{__('Education')}}</h2>
		</div>

        <!-- Start of Education Column -->
        <div class="row">
	        <div class="col-md-12">
	            <div class="item-block shadow-hover">

	                <!-- Start of Education Header -->
	                <div class="education-header clearfix">
	                    <img src="{{asset('/storage/images/original/MgaFzj35uBk9p8mchxikBXolhnFP5AGH.png')}}" alt="">
	                    <div>
	                        <h4>{{__('Bachelor')}} <small> - {{__('Computer Science')}}</small></h4>
	                        <h5>{{__('Obour Institute of Engineering & Technology')}}</h5>
	                    </div>
	                    <h6 class="time">2015 - 2020</h6>
	                </div>
	                <!-- End of Education Header -->

	                <!-- Start of Education Body -->
	                <div class="education-body">
	                    <p>{{__('Obour Institute mission')}}</p>
	                </div>
	                <!-- End of Education Body -->

	            </div>
	        </div>
        </div>
        <!-- End of Education Column -->

    </div>
</section>
<!-- ===== End of Education Section ===== -->





<!-- ===== Start of Work Experience Section ===== -->
<section class="work-experience">
    <div class="container">

		<div class="section-title">
			<h2 class="text-center">{{__('Work Experience')}}</h2>
		</div>

        <!-- Start of Work Experience Column -->
        <div class="row">
	        <div class="col-md-12">
	            <div class="item-block shadow-hover">

	                <!-- Start of Work Experience Header -->
	                <div class="experience-header clearfix">
	                    <img src="{{asset('/storage/images/original/MgaFzj35uBk9p8mchxikBXolhnFP5AGH.png')}}" alt="">
	                    <div>
	                        <h4>{{__('Obour Institute')}}</h4>
	                        <h5>{{__('Web Developer')}} | {{__('Server administrator')}} <small>({{__('volunteer')}})</small></h5>
	                    </div>
	                    <h6 class="time">2019 - 2020</h6>
	                </div>
	                <!-- End of Work Experience Header -->

	                <!-- Start of Work Experience Body -->
	                <div class="experience-body">
	                    <p>{{__('Responsibilities')}}:</p>
	                    <ul class="list">
	                        <li>{{__('installing/Manging open source web apps (Moodle,TAO, .... etc)')}}</li>
	                        <li>{{__('Manging Private server (Ubuntu server / Windows Server)')}}</li>
	                        <li>{{__('Develop a part of institute results systems')}}</li>
	                        <li>{{__('Developing Questionnaire platform')}}</li>
	                        <li>{{__('Setup ICPC Labs')}}</li>
	                    </ul>
	                </div>
	                <!-- End of Work Experience Body -->

	            </div>
	        </div>
        </div>
        <!-- End of Work Experience Column -->


    </div>
</section>
<!-- ===== End of Work Experience Section ===== -->













@include('themes.alnakhlawy.sections.call-to-action')



@endsection


@section('scripts')
	<script src="{{asset('assets/js/owl.carousel.min.js')}}"></script>
	<script src="{{asset('assets/js/venobox.min.js')}}"></script>
@endsection

@section('styles')
	<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/venobox.css')}}" />
	<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/owl.carousel.min.css')}}" />
@endsection
