@extends('themes.alnakhlawy.app')

@section('content')

<!-- =============== Start of Page Header 1 Section =============== -->
<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	<div class="container">

		<!-- Start of Page Title -->
		<div class="row">
			<div class="col-md-12">
				<h2>{{$title}}</h2>
			</div>
		</div>
		<!-- End of Page Title -->

		<!-- Start of Breadcrumb -->
		<div class="row">
			<div class="col-md-12">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{$title}}</li>
					</ol>
				</nav>
			</div>
		</div>
		<!-- End of Breadcrumb -->

	</div>
</section>
<!-- =============== End of Page Header 1 Section =============== -->

	<!-- ===== Start of Portfolio Section ===== -->
	<section class="portfolio">
	    <div class="container">

	        <!-- Start of Portfolio Grid -->
	        <div class="row portfolio-grid">

				@foreach($albums as $album)
		            <div class="element col-md-4 col-sm-6 col-xs-6">
		                <figure>
		                    <a href="{{$album->url}}" class="hover-zoom">
								<img src="{{$album->thumbnail(300)['src']}}" class="img-responsive" alt="{{$album->title}}">
		                    </a>
		                </figure>
		            </div>
				@endforeach

	        </div>
	        <!-- End of Portfolio Grid -->

	        <div class="row">
	            <div class="col-md-12">
	                <ul class="pagination list-inline text-center">
						{{ $albums->links() }}
	                </ul>
	            </div>
	        </div>

	    </div>
	</section>
	<!-- ===== End of Portfolio Section ===== -->
@endsection
