@extends('themes.alnakhlawy.app')

@section('content')

<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
    <div class="container">

        <!-- Start of Page Title -->
        <div class="row">
            <div class="col-md-12">
                <h2>{{$title}}</h2>
            </div>
        </div>
        <!-- End of Page Title -->

        <!-- Start of Breadcrumb -->
        <div class="row">
            <div class="col-md-12">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{$title}}</li>
					</ol>
				</nav>
            </div>
        </div>
        <!-- End of Breadcrumb -->

    </div>
</section>

<!-- ===== Start of Main Wrapper Section ===== -->
<section class="ptb80" id="contact">
    <div class="container">
        <div class="row">

			<div class="col-md-6 col-xs-12">
				{!! $page['content'] !!}
				<br>
				<div class="row">
					<div class="col-md-12">
						<div class="contact-icon">
                            <i class="fas fa-phone-alt col-md-4"></i>
                            <p class="col-md-8 TZPanelConfigEditor" data-key="contact_phone" data-value="{{ Config::get('app.contact.phone') }}">
                                <a href="tel:{{ Config::get('app.contact.phone') }}">{{ Config::get('app.contact.phone') }}</a>
                            </p>
						</div>

						<div class="contact-icon">
                            <i class="fas fa-at col-md-4"></i>
                            <p class="col-md-8 TZPanelConfigEditor" data-key="contact_email" data-value="{{ Config::get('app.contact.credential.email') }}">
                                <a href="mailto:{{ Config::get('app.contact.credential.email') }}">{{ Config::get('app.contact.credential.email') }}</a>
                            </p>
						</div>

						<div class="contact-icon">
                            <i class="fab fa-whatsapp col-md-4"></i>
                            <p class="col-md-8 TZPanelConfigEditor" data-key="whatsapp" data-value="{$config.whatsapp}">
								<a href="https://wa.me/{{ Config::get('app.contact.whatsapp') }}">{{ Config::get('app.contact.whatsapp') }}</a>
                            </p>
						</div>
					</div>
				</div>



			</div>

            <div class="col-md-6 col-xs-12">

				{{FormBuilder::Build(1)}}

                <!-- Start of Contact Form -->
                <!-- form id="contact-form" action="{{route('frontend.contact.submit')}}">

                    <div class="form-group">
                        <input class="form-control input-box" id="ContactName" type="text" name="name" placeholder="{{__('Your Name')}}" autocomplete="off">
                    </div>

					<div class="row">

                    <div class="form-group col-md-6">
                        <input class="form-control input-box" id="ContactEmail" type="email" name="email" placeholder="{{__('Enter Your Email')}}" autocomplete="off">
                    </div>


                    <div class="form-group  col-md-6">
                        <input class="form-control input-box" id="ContactPhone" type="tel" name="phone" placeholder="{{__('Phone Number')}}" autocomplete="off">
                    </div>
                    </div>


                    <div class="form-group">
                        <input class="form-control input-box" id="ContactSubject" type="text" name="subject" placeholder="{{__('Subject')}}" autocomplete="off">
                    </div>


                    <div class="form-group mb20">
                        <textarea class="form-control textarea-box" id="ContactMessage" rows="4" name="message" placeholder="{{__('Type your message')}}..."></textarea>
                    </div>


                    <div class="form-group text-right">
                        <button class="btn btn-default btn-effect" type="submit" id="SubmitContactForm">{{__('Send message')}} <i class="far fa-paper-plane"></i></button>
                    </div>
                </form -->
                <!-- End of Contact Form -->
            </div>

        </div>
    </div>
</section>
<!-- ===== End of Main Wrapper Section ===== -->
@endsection
