@extends('themes.alnakhlawy.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
	            <div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
				</div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of FAQ Section ===== -->
	<section class="ptb80" id="faq-page">
	    <div class="container">
	        <div class="row">
	            <div class="col-md-12">

	                <!-- Start of Second Row -->
	                <div class="row mt40">

						@foreach($faqs ?? [] as $faq)
							@php
							$locale = \App::getLocale();
							$faq = (array) $faq;
							$faq['question'] = $faq['question_'.$locale];
							$faq['answer'] = $faq['answer_'.$locale];
							@endphp
				            <div class="col-md-12 topic">
				                <div class="open">
				                    <h6 class="question" data-search-term="{{$faq['question']}}">
										{{$faq['question']}}
									</h6>
				                    <i class="fa fa-angle-down hidden-xs"></i>
				                </div>
				                <p class="answer">
				                    {{$faq['answer']}}
				                </p>
				            </div>
						@endforeach

	                </div>
	                <!-- End of Second Row -->

	            </div>
				<div class="col-md-12">
					<ul class="pagination list-inline text-center">
						{{ $faqs->links() }}
					</ul>
				</div>
	        </div>
	    </div>
	</section>
	<!-- ===== End of FAQ Section ===== -->
@endsection
