@extends('themes.alnakhlawy.app')

@section('content')

<!-- =============== Start of Page Header 1 Section =============== -->
<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	<div class="container">

		<!-- Start of Page Title -->
		<div class="row">
			<div class="col-md-12">
				<h2>{{$gallery->title}}</h2>
			</div>
		</div>
		<!-- End of Page Title -->

		<!-- Start of Breadcrumb -->
		<div class="row">
			<div class="col-md-12">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
						<li class="breadcrumb-item"><a href="{{route('frontend.albums.index')}}">{{__('Galleries')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{$gallery->title}}</li>
					</ol>
				</nav>
			</div>
		</div>
		<!-- End of Breadcrumb -->

	</div>
</section>
<!-- =============== End of Page Header 1 Section =============== -->

	<!-- ===== Start of Portfolio Section ===== -->
	<section class="portfolio">
	    <div class="container">

	        <!-- Start of Portfolio Grid -->
	        <div>
				{!! $gallery->content !!}
				<br>
				<br>
	        </div>

	        <div class="row portfolio-grid">

				@forelse($gallery->media as $image)
					<div class="element col-md-4 col-sm-6 col-xs-6 portfolio-cat1">
		                <figure>
		                    <a href="{{$image['src']}}" class="hover-zoom venobox">
								<img src="{{$image['src']}}" class="img-responsive" alt="">
		                    </a>
		                </figure>
		            </div>

				@empty
					<p class="col-md-12">{{__('Sorry, No images in this Gallery.')}}</p>
				@endforelse

	        </div>
	        <!-- End of Portfolio Grid -->


	    </div>
	</section>
	<!-- ===== End of Portfolio Section ===== -->
@endsection


@section('scripts')
	<script src="{{asset('assets/js/venobox.min.js')}}"></script>
@endsection

@section('styles')
	<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/venobox.css')}}" />
@endsection
