@extends('themes.alnakhlawy.app')

@section('content')

<!-- =============== Start of Page Header 1 Section =============== -->
<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	<div class="container">

		<!-- Start of Page Title -->
		<div class="row">
			<div class="col-md-12">
				<h2>{{$category->title}}</h2>
			</div>
		</div>
		<!-- End of Page Title -->

		<!-- Start of Breadcrumb -->
		<div class="row">
			<div class="col-md-12">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{$category->title}}</li>
					</ol>
				</nav>
			</div>
		</div>
		<!-- End of Breadcrumb -->

	</div>
</section>
<!-- =============== End of Page Header 1 Section =============== -->

	<!-- ===== Start of Portfolio Section ===== -->
	<section class="portfolio">
	    <div class="container">

	        <!-- Start of Portfolio Grid -->
	        <div class="row portfolio-grid">

				@foreach($posts as $post)
					@php
						$post->structure();
					@endphp
		            <div class="element col-md-4 col-sm-6 col-xs-6 portfolio-cat1">
		                <figure>
		                    <a href="{{$post->featuredImage['src']}}" class="hover-zoom venobox">
								<img src="{{$post->thumbnail(450)['src']}}" class="img-responsive" alt="{{$post->title}}">
		                    </a>
		                </figure>
		            </div>
				@endforeach

	        </div>
	        <!-- End of Portfolio Grid -->

	        <div class="row">
	            <div class="col-md-12">
	                <ul class="pagination list-inline text-center">
						{{ $posts->links() }}
	                </ul>
	            </div>
	        </div>

	    </div>
	</section>
	<!-- ===== End of Portfolio Section ===== -->
@endsection

@section('scripts')
	<script src="{{asset('assets/js/venobox.min.js')}}"></script>
@endsection

@section('styles')
	<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/venobox.css')}}" />
@endsection
