@extends('themes.alnakhlawy.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{$post->featuredImage['src']}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
	        <div class="row">
	            <div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item"><a href="{{route('frontend.page',['page_slug'=>'blog'])}}">{{__('blog')}}</a></li>
							<li class="breadcrumb-item"><a href="{{$post['category']->url}}">{{$post['category']['title']}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$post->title}}</li>
						</ol>
					</nav>
	            </div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Single Blog Post Section ===== -->
	<section id="blog-post">

	    <meta itemprop="datePublished" content="{{$post['created_at']}}" />
	    <meta itemprop="dateModified" content="{{$post['updated_at']}}" />
	    <meta itemprop="headline" content="{{$post['title']}}" />
	    <meta itemprop="description" content="{{$post['description']}}" />
	    <meta itemprop="image" content="{{$post->featuredImage['src']}}" />

	    <div class="container">
		    <div class="row">

		        <!-- Start of Blog Post Content Wrapper -->
		        <div class="col-md-8 col-xs-12 post-content-wrapper">

		            <!-- Start of Post Title -->
		            <div class="post-title">
		                <h2>{{$post['title']}}</h2>
		                <!-- Post Details -->
		                <div class="post-detail">
		                    <span><i class="far fa-user"></i>{{$post['user']['name']}}</span>
		                    <span><i class="far fa-clock"></i>{{ (new Carbon\Carbon($post['updated_at']))->diffForHumans()}}</span>
		                    <span><i class="far fa-comments"></i>{{count($post['comments'])}} {{__('Comments')}}</span>
		                </div>
		            </div>
		            <!-- End of Post Title -->

		            <!-- Start of Post Content -->
		            <div class="post-content">

		                {!! $post['content'] !!}

		                <hr>

		                <!-- WORK NAVIGATION -->
		                <div class="work-navigation clearfix">
		                    <a dir="ltr" @if(!empty($post['Prev'])) href="{{$post.Prev.URL}}" @endif class="work-prev" data-type="simple" data-key="Prev"><span><span class="fas fa-angle-left"></span> {{__('Prev')}} </span></a>
		                    <a href="/blog/" class="work-all" data-type="simple" data-key="AllPosts"><span>{{__('All Posts')}}</span></a>
		                    <a dir="ltr" @if(!empty($post['Next'])) href="{{$post.Next.URL}}" @endif class="work-next"><span data-type="simple" data-key="Next"> {{__('Next')}} <span class="fas fa-angle-right"></span></span></a>
		                </div>

		                <hr>

						<div class="text-center">
							<!-- Start of Social Media Buttons -->
						    <ul class="social-btns list-inline">
			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.facebook.com/sharer.php?t={{$post['title']}}&u={{$post->url}}" class="social-btn-roll facebook">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
			                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://twitter.com/intent/tweet?text=&url={{$post->url}}" class="social-btn-roll twitter">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-twitter"></i>
			                                <i class="social-btn-roll-icon fab fa-twitter"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.pinterest.com/pin/create/button/?description={{$post['description']}}&media={{$post->featuredImage['src']}}&url={{$post->url}}" class="social-btn-roll pinterest">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-pinterest-p"></i>
			                                <i class="social-btn-roll-icon fab fa-pinterest-p"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.linkedin.com/shareArticle?title={{$post['title']}}&url={{$post->url}}" class="social-btn-roll linkedin">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
			                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
			                            </div>
			                        </a>
			                    </li>
			                </ul>
			                <!-- End of Social Media Buttons -->
						</div>


		                <!-- Start of Blog Post Comments -->
		                <div class="mt60" id="blog-comments">
		                    <div class="main-content">

		                        <h4 class="py-4">{{count($post['comments'])}} {{__('comments')}}</h4>

		                        <!-- Start of Comment List -->
		                        <ul class="comments-list">

		                            @forelse($post['comments'] ?? [] as $Comment)
		                            <li class="comment">
		                                <!-- Commenter Image -->
		                                <a class="pull-left commenter" href="#">
		                                    <img src="{{Afrodien::getGravatar($Comment['email'].$Comment['user']['email'])}}" alt="{{$Comment['name']}}" class="img-responsive" />
		                                </a>

		                                <div class="media-body comment-body">
		                                    <!-- Comment Wrapper -->
		                                    <div class="comment-content-wrapper">
		                                        <div class="media-heading clearfix">

		                                            <!-- Commenters Name -->
		                                            <h6 class="commenter-name">{{$Comment['user']['name']}}{{$Comment['name']}}</h6>

		                                            <div class="comment-reply">
		                                                <a href="javascript:void(0)" class="btn btn-default btn-sm btn-effect">{{__('reply')}}</a>
		                                            </div>

		                                            <!-- Comment Info -->
		                                            <div class="comment-info">
		                                                <span>{{$Comment->created_at->diffForHumans()}}</span>
		                                            </div>

		                                            <!-- Comment -->
		                                            <p>{{$Comment['body']}}</p>
		                                        </div>

		                                        <!-- ==== Start of Comment Replies ==== -->
		                                        <ul class="comment-replies">
		                                            @foreach($Comment['replies'] ?? [] as $reply)
			                                            <li class="comment-replied">
			                                                <a class="commenter" href="#">
			                                                    <img src="{{Afrodien::getGravatar($reply['email'].$reply['user']['email'])}}" alt="{{$reply['name']}}" class="img-responsive" />
			                                                </a>
			                                                <div class="media-body comment-body">
			                                                    <div class="comment-content-wrapper">
			                                                        <div class="media-heading clearfix">
			                                                            <h6 class="commenter-name">{{$reply['user']['name']}}{{$reply['name']}}</h6>
			                                                            <div class="comment-info">
																			<span>{{$reply->created_at->diffForHumans()}}</span>
			                                                            </div>
																		<p>{{$reply['body']}}</p>
			                                                        </div>
			                                                    </div>
			                                                </div>
			                                            </li>
													@endforeach
		                                        </ul>
		                                        <!-- ==== End of Comment Replies ==== -->
		                                    </div>
		                                    <!-- End of Comment Wrapper -->
		                                </div>
		                            </li>
									@empty
										<li class="comment">
											<p>No, comments yet</p>
										</li>
		                            @endforelse
		                        </ul>
		                        <!-- End of Comment List -->

		                        @if(\Config::get('app.comments.status') == "opened" || \Config::get('app.comments.status')  == "FacebookAndComments" || (\Config::get('app.comments.status')  == "Member" && Auth::check()))

		                        <!-- Start of Comment Submit Form -->
		                        <h4 class="pb-2">{{__('Leave a comment')}}</h4>

		                        <form class="row" action="{{route('frontend.blog.comments.submit')}}" data-id="{{$post['id']}}" id="comment-form" method="post">
									<br>
		                            @if(!Auth::check())
		                                <div class="col-md-6 form-group">
		                                    <input class="form-control input-box" type="text" id="name" name="name" placeholder="{{__('Your Name')}}" />
		                                </div>

		                                <div class="col-md-6 form-group">
		                                    <input class="form-control input-box" type="email" id="email" name="email" placeholder="your@email.com" />
		                                </div>
		                            @endif

		                            <div class="col-md-12 form-group mb30">
		                                <textarea class="form-control textarea-box" rows="8" id="comment" name="comment" placeholder="{{__('Type your comment')}}..."></textarea>
		                            </div>
		                            <div class="col-md-12 col-xs-12 comment-submit">
		                                <button class="btn btn-default btn-effect" id="submit-comment" type="submit">{{__('Submit')}} <i class="far fa-paper-plane"></i> </button>
		                            </div>
		                        </form>
		                        <!-- End of Comment Submit Form -->
								@else
		                            @if(\Config::get('app.comments.status') == "Member" && !Auth::check())
		                                <p>{{__('Comments for Member Only')}}</p>
		                            @else
		                                @if(\Config::get('app.comments.status') != "Facebook")
		                                    <p>{{__('Comments Closed')}}</p>
		                                @endif
		                            @endif
		                        @endif

		                    </div>
		                </div>
		                <!-- Start of Blog Post Comments -->

		            </div>
		            <!-- End of Post Content -->

		        </div>
		        <!-- End of Blog Post Content Wrapper -->

		        <div class="col-md-4 col-xs-12 blog-sidebar">
					@include('themes.alnakhlawy.inc.aside')
		        </div>

		    </div>
	    </div>
	</section>
	<!-- ===== End of Single Blog Post Section ===== -->
@endsection


@section('scripts')
	<script src="{{asset('plugins/sticky/jquery.sticky-kit.js')}}"></script>
@endsection
