@extends('themes.alnakhlawy.app')

@section('content')

	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$page->title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
	            <div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
	            </div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Shop Section ===== -->
	<section class="shop ptb80">
	    <div class="container">
	        <div class="row">

	            <!-- Start of Shop Product Wrapper -->
	            <div class="col-md-12 col-xs-12 shop-products-wrapper">

	                <!-- Start of Products -->
	                <div class="row">

	                    @foreach($products  as $product)
	                    <div class="col-md-4 col-sm-6 col-xs-12">
	                        <div class="product">

	                            <!-- Product Image -->
	                            <div class="product-image">

	                                <a href="{{$product->url}}" class="hover-zoom">
	                                    <img src="{{$product->featuredImage['src']}}" class="img-responsive" alt="{{$product->title}}" />
	                                </a>

	                                <!-- Product overlay -->
	                                <div class="product-overlay">
	                                    <a href="{{$product->url}}"><i class="fa fa-shopping-cart"></i>Add to Cart</a>
	                                </div>

	                            </div>

	                            <!-- Product Description -->
	                            <div class="product-descr">

	                                <a href="{{$product->url}}">
	                                    <h4>{{$product->title}}</h4>

	                                    <!-- Price -->
	                                    <span class="price">
											@empty($product->special_price)
												<span class="amount">${{$product->price}}</span>
											@else
												<del><span class="amount">${{$product->price}}</span></del>
			                                    <span class="amount">${{$product->special_price}}</span>
											@endempty
	                                    </span>
	                                </a>
	                            </div>

	                        </div>
	                    </div>
	                    @endforeach




	                </div>
	                <!-- End of Products -->


	                <!-- Start of Pagination -->
	                <div class="row">
	                    <div class="col-md-12">
	                        <ul class="pagination list-inline text-center">
								{!! $products->links() !!}
	                        </ul>
	                    </div>
	                </div>
	                <!-- End of Pagination -->

	            </div>
	            <!-- End of Shop Product Wrapper -->

	        </div>
	    </div>
	</section>
	<!-- ===== End of Shop Section ===== -->


@endsection
