<!DOCTYPE html>

<html lang="{{Config::get('app.locale')}}" dir="{{json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']}}" itemscope itemtype="http://schema.org/WebPage" prefix="og: http://ogp.me/ns#">
    <head @if(isset($Post) and !empty($Post)) typeof="og:article" @elsetypeof="og:website" @endif>
        <meta charset="UTF-8" />

        <!-- Mobile viewport optimized -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1" />
        <base href="{{url('')}}" />
        <meta name="home" content="{{route('frontend.index')}}" />

        <title>{{config('app.name')[config('app.locale')] }} | {{$title}}</title>

        <!-- SEO Specific Metas -->
        <meta name="robots" content="{{$meta['robots']}}" />
        <meta name="description" content="{{$meta['description']}}" />
        <meta name="Author" content="Afrodien Panel" />
        <meta name="keywords" content="{{$meta['keywords']}}" />
        <!-- Schema.org markup for Google+ -->
        <meta itemprop="name" content="{{Config::get('app.name')[Config::get('app.locale')] }}" />
        <meta itemprop="description" content="{{$meta['description']}}" />
        <meta itemprop="image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Twitter Card data -->
        <meta name="twitter:card" content="summary_large_image" />
        <meta name="twitter:site" content="{{Config::get('app.social.twitter')}}" />
        <meta name="twitter:title" content="{{$meta['title']}}" />
        <meta name="twitter:description" content="{{$meta['description']}}" />
        <meta name="twitter:image" content="{{$meta['featuredImage']['src']}}" />

        <!-- Open Graph data -->
        <meta property="fb:app_id" content="{{Config::get('app.social.facebook.app')}}" />
        @if(isset($Post) and !empty($Post))
        <meta property="og:type" content="article" />
        @else
        <meta property="og:type" content="website" />
        @endif
        <meta property="og:title" content="{{$meta['title']}}" />
        <meta property="og:image" content="{{$meta['featuredImage']['src']}}" />
        <meta property="og:image:type" content="{{$meta['featuredImage']['type']}}" />
        <meta property="og:image:width" content="{{$meta['featuredImage']['width']}}" />
        <meta property="og:image:height" content="{{$meta['featuredImage']['height']}}" />
        <meta property="og:description" content="{{$meta['description']}}" />
        <meta property="og:url" content="{{Config::get('app.default.url')}}" />
        <meta property="fb:pages" content="{{Config::get('app.social.facebook.page')}}" />

        <!-- Site Map -->
        <link rel="sitemap" type="application/xml" title="Sitemap" href="{{route('sitemap.index')}}" />

        <!-- Setup Multi languages -->
        <link rel="alternate" href="{{Config::get('app.default.clean-url')}}" hreflang="x-default" />
        @foreach(Config::get('app.languages') as $language) <link rel="alternate" href="{{url($language->prefix."/".Config::get('app.default.clean-uri'))}}" hreflang="{{$language->prefix}}" /> @endforeach

        <!-- Theme Color -->
        <meta name="theme-color" content="{{Config::get('app.default.color')}}" />
        <meta name="msapplication-navbutton-color" content="{{Config::get('app.default.color')}}" />

        <!-- iOS Safari -->
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="{{Config::get('app.default.color')}}" />

        <!-- Canonical Tag -->
        <link rel="canonical" href="{{$meta['canonical']}}" />

        @if(isset($Post) and !empty($Post)) @if(isset($Post['Prev']['URL']))
        <link rel="prev" href="{$Post.Prev.URL}" />
        @endif @if(isset($Post['Next']['URL']))
        <link rel="next" href="{$Post.Next.URL}" />
        @endif @endif

        <script defer type="application/ld+json">
            {
                "@context": "http://schema.org",
                "@type": "WebSite",
                "url": "{{route('frontend.index')}}",
                "potentialAction": { "@type": "SearchAction", "target": "search/{search_term_string}", "query-input": "required name=search_term_string" }
            }
        </script>
        <script defer type="application/ld+json">
            {"@context": "https://schema.org","@type": "Organization","url": "{{route('frontend.index')}}","logo": "{{url('/storage/'.config('app.logo.src'))}}","telephone": "{{config('app.contact.phone')}}","name": "{{config('app.name')[config('app.locale')]}}","legalName": "{{config('app.name')[config('app.locale')]}}","description": "{{config('app.description')[config('app.locale')]}}","sameAs": [ @if (!empty(Config::get('app.social.twitter'))) "https://twitter.com/{{Config::get('app.social.twitter')}}", @endif @if (!empty(Config::get('app.social.instagram'))) "https://www.instagram.com/{{Config::get('app.social.instagram')}}", @endif @if (!empty(Config::get('app.social.linkedin'))) "https://www.linkedin.com/in/{{Config::get('app.social.linkedin')}}", @endif @if (!empty(Config::get('app.social.facebook.page'))) "https://www.facebook.com/{{Config::get('app.social.facebook.page')}}" @endif ]}
        </script>

        <meta name="csrf-token" content="{{csrf_token()}}" />

        <script type="text/javascript">
            window._wpemojiSettings = {
                baseUrl: "https:\/\/s.w.org\/images\/core\/emoji\/13.0.0\/72x72\/",
                ext: ".png",
                svgUrl: "https:\/\/s.w.org\/images\/core\/emoji\/13.0.0\/svg\/",
                svgExt: ".svg",
                source: { concatemoji: "https:\/\/www.tameer-sa.com\/wp-includes\/js\/wp-emoji-release.min.js?ver=5.5.3" },
            };
            !(function (e, a, t) {
                var r,
                    n,
                    o,
                    i,
                    p = a.createElement("canvas"),
                    s = p.getContext && p.getContext("2d");
                function c(e, t) {
                    var a = String.fromCharCode;
                    s.clearRect(0, 0, p.width, p.height), s.fillText(a.apply(this, e), 0, 0);
                    var r = p.toDataURL();
                    return s.clearRect(0, 0, p.width, p.height), s.fillText(a.apply(this, t), 0, 0), r === p.toDataURL();
                }
                function l(e) {
                    if (!s || !s.fillText) return !1;
                    switch (((s.textBaseline = "top"), (s.font = "600 32px Arial"), e)) {
                        case "flag":
                            return (
                                !c([127987, 65039, 8205, 9895, 65039], [127987, 65039, 8203, 9895, 65039]) &&
                                !c([55356, 56826, 55356, 56819], [55356, 56826, 8203, 55356, 56819]) &&
                                !c(
                                    [55356, 57332, 56128, 56423, 56128, 56418, 56128, 56421, 56128, 56430, 56128, 56423, 56128, 56447],
                                    [55356, 57332, 8203, 56128, 56423, 8203, 56128, 56418, 8203, 56128, 56421, 8203, 56128, 56430, 8203, 56128, 56423, 8203, 56128, 56447]
                                )
                            );
                        case "emoji":
                            return !c([55357, 56424, 8205, 55356, 57212], [55357, 56424, 8203, 55356, 57212]);
                    }
                    return !1;
                }
                function d(e) {
                    var t = a.createElement("script");
                    (t.src = e), (t.defer = t.type = "text/javascript"), a.getElementsByTagName("head")[0].appendChild(t);
                }
                for (i = Array("flag", "emoji"), t.supports = { everything: !0, everythingExceptFlag: !0 }, o = 0; o < i.length; o++)
                    (t.supports[i[o]] = l(i[o])), (t.supports.everything = t.supports.everything && t.supports[i[o]]), "flag" !== i[o] && (t.supports.everythingExceptFlag = t.supports.everythingExceptFlag && t.supports[i[o]]);
                (t.supports.everythingExceptFlag = t.supports.everythingExceptFlag && !t.supports.flag),
                    (t.DOMReady = !1),
                    (t.readyCallback = function () {
                        t.DOMReady = !0;
                    }),
                    t.supports.everything ||
                        ((n = function () {
                            t.readyCallback();
                        }),
                        a.addEventListener
                            ? (a.addEventListener("DOMContentLoaded", n, !1), e.addEventListener("load", n, !1))
                            : (e.attachEvent("onload", n),
                              a.attachEvent("onreadystatechange", function () {
                                  "complete" === a.readyState && t.readyCallback();
                              })),
                        (r = t.source || {}).concatemoji ? d(r.concatemoji) : r.wpemoji && r.twemoji && (d(r.twemoji), d(r.wpemoji)));
            })(window, document, window._wpemojiSettings);
        </script>
        <style type="text/css">
            img.wp-smiley,
            img.emoji {
                display: inline !important;
                border: none !important;
                box-shadow: none !important;
                height: 1em !important;
                width: 1em !important;
                margin: 0 0.07em !important;
                vertical-align: -0.1em !important;
                background: none !important;
                padding: 0 !important;
            }
        </style>
        <link rel="stylesheet" id="dashicons-css" href="wp-includes/css/dashicons.min5697.css?ver=5.5.3" type="text/css" media="all" />
        <link rel="stylesheet" id="thickbox-css" href="wp-includes/js/thickbox/thickbox5697.css?ver=5.5.3" type="text/css" media="all" />
        <link rel="stylesheet" id="wp-block-library-css" href="wp-includes/css/dist/block-library/style.min5697.css?ver=5.5.3" type="text/css" media="all" />
        <link rel="stylesheet" id="wc-block-vendors-style-css" href="wp-content/plugins/woocommerce/packages/woocommerce-blocks/build/vendors-style324d.css?ver=3.1.0" type="text/css" media="all" />
        <link rel="stylesheet" id="wc-block-style-css" href="wp-content/plugins/woocommerce/packages/woocommerce-blocks/build/style324d.css?ver=3.1.0" type="text/css" media="all" />
        <link rel="stylesheet" id="bbp-default-css" href="wp-content/plugins/bbpress/templates/default/css/bbpress.min6770.css?ver=2.6.5" type="text/css" media="all" />
        <link rel="stylesheet" id="wpcdt-public-css-css" href="wp-content/plugins/countdown-timer-ultimate/assets/css/wpcdt-timecircles54f4.css?ver=1.2.5" type="text/css" media="all" />
        <link rel="stylesheet" id="cms-plugin-stylesheet-css" href="wp-content/plugins/ctcore/assets/css/cms-style5697.css?ver=5.5.3" type="text/css" media="all" />
        <link property="stylesheet" rel="stylesheet" id="owl-carousel-css" href="wp-content/plugins/ctcore/assets/css/owl.carousel.min5697.css?ver=5.5.3" type="text/css" media="all" />
        <link rel="stylesheet" id="rs-plugin-settings-css" href="wp-content/plugins/revslider/public/assets/css/rs63781.css?ver=6.2.2" type="text/css" media="all" />
        <style id="rs-plugin-settings-inline-css" type="text/css">
            #rs-demo-id {
            }
        </style>
        <link rel="stylesheet" id="woocommerce-layout-css" href="wp-content/plugins/woocommerce/assets/css/woocommerce-layout3428.css?ver=4.5.2" type="text/css" media="all" />
        <link rel="stylesheet" id="woocommerce-smallscreen-css" href="wp-content/plugins/woocommerce/assets/css/woocommerce-smallscreen3428.css?ver=4.5.2" type="text/css" media="only screen and (max-width: 768px)" />
        <link rel="stylesheet" id="woocommerce-general-css" href="wp-content/plugins/woocommerce/assets/css/woocommerce3428.css?ver=4.5.2" type="text/css" media="all" />
        <style id="woocommerce-inline-inline-css" type="text/css">
            .woocommerce form .form-row .required {
                visibility: visible;
            }
        </style>
        <link rel="stylesheet" id="ptpdffrontend-css" href="wp-content/plugins/wp-advanced-pdf/asset/css/front_endd279.css?ver=1.1.5" type="text/css" media="all" />
        <link rel="stylesheet" id="wpml-legacy-horizontal-list-0-css" href="wp-content/plugins/sitepress-multilingual-cms/templates/language-switchers/legacy-list-horizontal/style68b3.css?ver=1" type="text/css" media="all" />
        <link rel="stylesheet" id="bookly-intlTelInput.css-css" href="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/css/intlTelInput9670.css?ver=18.8" type="text/css" media="all" />
        <link rel="stylesheet" id="bookly-ladda.min.css-css" href="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/css/ladda.min9670.css?ver=18.8" type="text/css" media="all" />
        <link rel="stylesheet" id="bookly-picker.classic.css-css" href="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/css/picker.classic9670.css?ver=18.8" type="text/css" media="all" />
        <link rel="stylesheet" id="bookly-picker.classic.date.css-css" href="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/css/picker.classic.date9670.css?ver=18.8" type="text/css" media="all" />
        <link rel="stylesheet" id="bookly-main.css-css" href="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/css/bookly-main9670.css?ver=18.8" type="text/css" media="all" />
		<link rel="stylesheet" id="bootstrap-css" href="wp-content/themes/archio/assets/css/bootstrap.mincce7.css?ver=4.0.0" type="text/css" media="all" />
        <link rel="stylesheet" id="font-awesome-css" href="wp-content/plugins/elementor/assets/lib/font-awesome/css/font-awesome.min1849.css?ver=4.7.0" type="text/css" media="all" />
        <link rel="stylesheet" id="font-awesome-v5-css" href="wp-content/themes/archio/assets/css/font-awesome5.min9f31.css?ver=5.7.2" type="text/css" media="all" />
        <link rel="stylesheet" id="font-awesome-shims-css" href="wp-content/themes/archio/assets/css/font-awesome5-shims.min9f31.css?ver=5.7.2" type="text/css" media="all" />
        <link rel="stylesheet" id="font-material-icon-css" href="wp-content/themes/archio/assets/css/material-design-iconic-font.min3601.css?ver=2.2.0" type="text/css" media="all" />
        <link rel="stylesheet" id="flaticon-css" href="wp-content/themes/archio/assets/css/flaticon8a54.css?ver=1.0.0" type="text/css" media="all" />
        <link rel="stylesheet" id="themify-icons-css" href="wp-content/themes/archio/assets/css/themify-icons8a54.css?ver=1.0.0" type="text/css" media="all" />
        <link rel="stylesheet" id="font-etline-icon-css" href="wp-content/themes/archio/assets/css/et-line8a54.css?ver=1.0.0" type="text/css" media="all" />
        <link rel="stylesheet" id="magnific-popup-css" href="wp-content/themes/archio/assets/css/magnific-popup8a54.css?ver=1.0.0" type="text/css" media="all" />
        <link rel="stylesheet" id="archio-theme-css" href="wp-content/themes/archio/assets/css/theme19f6.css?ver=1.0.7" type="text/css" media="all" />
        <style id="archio-theme-inline-css" type="text/css">
            #header-wrap .header-branding a img {
                max-height: 80px;
            }
            @media screen and (min-width: 992px) {
            }

            .h-btn-sidebar {
                display: none !important;
            }
        </style>
        <link rel="stylesheet" id="archio-menu-css" href="wp-content/themes/archio/assets/css/menu19f6.css?ver=1.0.7" type="text/css" media="all" />
        <link rel="stylesheet" id="archio-style-css" href="wp-content/themes/archio/style5697.css?ver=5.5.3" type="text/css" media="all" />
        <link
            rel="stylesheet"
            id="archio-google-fonts-css"
            href="https://fonts.googleapis.com/css?family=Heebo%3A300%2C400%2C500%2C600%2C700%7CMuli%3A300%2C400%2C500%2C600%2C700%7CPoppins%3A300%2C400%2C500%2C600%2C700%7CPlayfair+Display%3A400%2C400i%2C700%2C700i%7COpen+Sans%3A400%2C500%2C600%2C700&#038;subset=latin%2Clatin-ext&#038;ver=5.5.3"
            type="text/css"
            media="all"
        />
        <link rel="stylesheet" id="newsletter-css" href="wp-content/plugins/newsletter/stylef22c.css?ver=6.8.7" type="text/css" media="all" />
        <link rel="stylesheet" id="js_composer_front-css" href="wp-content/plugins/js_composer/assets/css/js_composer.min10df.css?ver=6.2.0" type="text/css" media="all" />
        <link rel="stylesheet" id="zakeke-glide-css" href="wp-content/plugins/zakeke-interactive-product-designer/assets/css/frontend/libs/glide.coreb212.css?ver=2.2.12" type="text/css" media="all" />
        <link rel="stylesheet" id="zakeke-glide-theme-css" href="wp-content/plugins/zakeke-interactive-product-designer/assets/css/frontend/libs/glide.themeb212.css?ver=2.2.12" type="text/css" media="all" />
        <link rel="stylesheet" id="zakeke-shop-css" href="wp-content/plugins/zakeke-interactive-product-designer/assets/css/frontend/shopb212.css?ver=2.2.12" type="text/css" media="all" />
        <link rel="stylesheet" id="zakeke-configurator-css" href="wp-content/plugins/zakeke-interactive-product-designer/assets/css/frontend/configuratorb212.css?ver=2.2.12" type="text/css" media="all" />
		<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
        <script type="text/javascript" src="wp-content/plugins/revslider/public/assets/js/rbtools.minf049.js?ver=6.0" id="tp-tools-js"></script>
        <script type="text/javascript" src="wp-content/plugins/revslider/public/assets/js/rs6.min3781.js?ver=6.2.2" id="revmin-js"></script>
        <script type="text/javascript" src="wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min44fd.js?ver=2.70" id="jquery-blockui-js"></script>

        <script type="text/javascript" src="wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min3428.js?ver=4.5.2" id="wc-add-to-cart-js"></script>
        <script type="text/javascript" id="ajaxsave-js-extra">
            /* <![CDATA[ */
            var postajaxsave = { ajax_url: "https:\/\/www.tameer-sa.com\/wp-admin\/admin-ajax.php", baseUrl: "https:\/\/www.tameer-sa.com\/wp-content\/plugins\/wp-advanced-pdf" };
            /* ]]> */
        </script>
        <script type="text/javascript" src="wp-content/plugins/wp-advanced-pdf/asset/js/ajaxsaved279.js?ver=1.1.5" id="ajaxsave-js"></script>
        <script type="text/javascript" src="wp-content/plugins/zakeke-interactive-product-designer/assets/js/frontend/product-pageb212.js?ver=2.2.12" id="zakeke-product-page-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/spin.min9670.js?ver=18.8" id="bookly-spin.min.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/ladda.min9670.js?ver=18.8" id="bookly-ladda.min.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/hammer.min9670.js?ver=18.8" id="bookly-hammer.min.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/jquery.hammer.min9670.js?ver=18.8" id="bookly-jquery.hammer.min.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/picker9670.js?ver=18.8" id="bookly-picker.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/picker.date9670.js?ver=18.8" id="bookly-picker.date.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/intlTelInput.min9670.js?ver=18.8" id="bookly-intlTelInput.min.js-js"></script>
        <script type="text/javascript" id="bookly.min.js-js-extra">
            /* <![CDATA[ */
            var BooklyL10n = {
                ajaxurl: "https:\/\/www.tameer-sa.com\/wp-admin\/admin-ajax.php?lang=en",
                csrf_token: "0dab029edb",
                today: "Today",
                months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                daysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                nextMonth: "Next month",
                prevMonth: "Previous month",
                show_more: "Show more",
            };
            /* ]]> */
        </script>
        <script type="text/javascript" src="wp-content/plugins/bookly-responsive-appointment-booking-tool/frontend/resources/js/bookly.min9670.js?ver=18.8" id="bookly.min.js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/js_composer/assets/js/vendors/woocommerce-add-to-cart10df.js?ver=6.2.0" id="vc_woocommerce-add-to-cart-js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/zakeke-interactive-product-designer/assets/js/frontend/libs/glideb212.js?ver=2.2.12" id="zakeke-glide-js"></script>
        <script type="text/javascript" src="wp-content/plugins/zakeke-interactive-product-designer/assets/js/frontend/shopb212.js?ver=2.2.12" id="zakeke-shop-js"></script>
        <script type="text/javascript" src="wp-content/plugins/zakeke-interactive-product-designer/assets/js/frontend/configuratorb212.js?ver=2.2.12" id="zakeke-configurator-js"></script>
        <div id="examplePopup1" style="display: none;">
            <div style="float: left; padding: 20px 20px 20px 20px;">
                <h4>Enter your email Address</h4>
                <input type="text" style="margin-top: 10px;" name="useremailID" id="useremailID" /><input type="hidden" id="emailpostID" />
                <input id="guest_email" style="margin-top: 10px;" class="button-primary" type="submit" name="email_submit" value="submit" />
            </div>
        </div>
        <noscript>
            <style>
                .woocommerce-product-gallery {
                    opacity: 1 !important;
                }
            </style>
        </noscript>
        <style type="text/css">
            .recentcomments a {
                display: inline !important;
                padding: 0 !important;
                margin: 0 !important;
            }
        </style>

        <script type="text/javascript">
            function setREVStartSize(e) {
                try {
                    var pw = document.getElementById(e.c).parentNode.offsetWidth,
                        newh;
                    pw = pw === 0 || isNaN(pw) ? window.innerWidth : pw;
                    e.tabw = e.tabw === undefined ? 0 : parseInt(e.tabw);
                    e.thumbw = e.thumbw === undefined ? 0 : parseInt(e.thumbw);
                    e.tabh = e.tabh === undefined ? 0 : parseInt(e.tabh);
                    e.thumbh = e.thumbh === undefined ? 0 : parseInt(e.thumbh);
                    e.tabhide = e.tabhide === undefined ? 0 : parseInt(e.tabhide);
                    e.thumbhide = e.thumbhide === undefined ? 0 : parseInt(e.thumbhide);
                    e.mh = e.mh === undefined || e.mh == "" || e.mh === "auto" ? 0 : parseInt(e.mh, 0);
                    if (e.layout === "fullscreen" || e.l === "fullscreen") newh = Math.max(e.mh, window.innerHeight);
                    else {
                        e.gw = Array.isArray(e.gw) ? e.gw : [e.gw];
                        for (var i in e.rl) if (e.gw[i] === undefined || e.gw[i] === 0) e.gw[i] = e.gw[i - 1];
                        e.gh = e.el === undefined || e.el === "" || (Array.isArray(e.el) && e.el.length == 0) ? e.gh : e.el;
                        e.gh = Array.isArray(e.gh) ? e.gh : [e.gh];
                        for (var i in e.rl) if (e.gh[i] === undefined || e.gh[i] === 0) e.gh[i] = e.gh[i - 1];

                        var nl = new Array(e.rl.length),
                            ix = 0,
                            sl;
                        e.tabw = e.tabhide >= pw ? 0 : e.tabw;
                        e.thumbw = e.thumbhide >= pw ? 0 : e.thumbw;
                        e.tabh = e.tabhide >= pw ? 0 : e.tabh;
                        e.thumbh = e.thumbhide >= pw ? 0 : e.thumbh;
                        for (var i in e.rl) nl[i] = e.rl[i] < window.innerWidth ? 0 : e.rl[i];
                        sl = nl[0];
                        for (var i in nl)
                            if (sl > nl[i] && nl[i] > 0) {
                                sl = nl[i];
                                ix = i;
                            }
                        var m = pw > e.gw[ix] + e.tabw + e.thumbw ? 1 : (pw - (e.tabw + e.thumbw)) / e.gw[ix];

                        newh = (e.type === "carousel" && e.justify === "true" ? e.gh[ix] : e.gh[ix] * m) + (e.tabh + e.thumbh);
                    }

                    if (window.rs_init_css === undefined) window.rs_init_css = document.head.appendChild(document.createElement("style"));
                    document.getElementById(e.c).height = newh;
                    window.rs_init_css.innerHTML += "#" + e.c + "_wrapper { height: " + newh + "px }";
                } catch (e) {
                    console.log("Failure at Presize of Slider:" + e);
                }
            }
        </script>
        <style type="text/css" id="wp-custom-css">
            .ct-fancybox-more-link.btn-line {
                display: none;
            }
        </style>
        <style id="cms_theme_options-dynamic-css" title="dynamic-css" class="redux-options-output">
            .primary-menu li a {
                font-display: swap;
            }
            a {
                color: #c5984f;
            }
            a:hover {
                color: #9b6f45;
            }
            a:active {
                color: #9b6f45;
            }
            body {
                font-display: swap;
            }
            h1,
            .h1,
            .text-heading {
                font-display: swap;
            }
            h2,
            .h2 {
                font-display: swap;
            }
            h3,
            .h3 {
                font-display: swap;
            }
            h4,
            .h4 {
                font-display: swap;
            }
            h5,
            .h5 {
                font-display: swap;
            }
            h6,
            .h6 {
                font-display: swap;
            }
        </style>
        <style type="text/css" id="cms-page-dynamic-css">
            #content {
                padding-top: 0px;
                padding-bottom: 0px;
            }
        </style>
        <style type="text/css" data-type="vc_custom-css">
            @media screen and (min-width: 768px) {
                .ct-client-carousel .ct-client-item a {
                    display: inherit;
                }
                .ct-client-carousel .owl-nav {
                    margin-top: 130px;
                    text-align: right;
                }
            }
        </style>
        <style type="text/css" data-type="vc_shortcodes-custom-css">
            .vc_custom_1552925396318 {
                padding-top: 110px !important;
                padding-bottom: 110px !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
                background-size: cover !important;
            }
            .vc_custom_1553186234397 {
                padding-top: 78px !important;
                padding-bottom: 108px !important;
                background: #272727 !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
                background-size: cover !important;
            }
            .vc_custom_1552920422705 {
                background-color: #000000 !important;
            }
            .vc_custom_1553652443041 {
                padding-top: 80px !important;
                padding-bottom: 40px !important;
                background-position: center;
                background-repeat: no-repeat;
                background-size: cover;
            }
            .vc_custom_1552920422705 {
                background-color: #000000 !important;
            }
            .vc_custom_1552813034346 {
                padding-top: 0px !important;
            }
            .vc_custom_1552902458867 {
                padding-top: 0px !important;
                padding-left: 35px !important;
            }
            .vc_custom_1589979359237 {
                margin-bottom: 0px !important;
                padding-top: 20px !important;
            }
            .vc_custom_1553185907162 {
                padding-top: 0px !important;
            }
            .vc_custom_1553218647304 {
                padding-top: 30px !important;
            }
            .vc_custom_1553218656444 {
                padding-top: 30px !important;
            }
            .vc_custom_1553218664032 {
                padding-top: 30px !important;
            }
            .vc_custom_1552709233494 {
                padding-top: 0px !important;
            }
            .vc_custom_1552920415316 {
                padding-top: 130px !important;
            }
            .vc_custom_1552924507632 {
                padding-top: 0px !important;
                padding-right: 25px !important;
            }
            .vc_custom_1552924513372 {
                padding-top: 0px !important;
                padding-left: 93px !important;
            }
            .vc_custom_1589981077358 {
                margin-bottom: 0px !important;
                padding-top: 0px !important;
            }
            .vc_custom_1552923835415 {
                padding-top: 65px !important;
            }
            .vc_custom_1552923825582 {
                padding-top: 65px !important;
            }
            .vc_custom_1552923845488 {
                padding-top: 65px !important;
            }
            .vc_custom_1552923854215 {
                padding-top: 65px !important;
            }
            .vc_custom_1553218849632 {
                padding-top: 120px !important;
            }
            .vc_custom_1553225917830 {
                padding-top: 102px !important;
            }
            .vc_custom_1553223877435 {
                padding-top: 0px !important;
            }
            .vc_custom_1553592012441 {
                padding-top: 0px !important;
                padding-left: 25px !important;
            }
            .vc_custom_1553591829233 {
                margin-bottom: 0px !important;
                padding-top: 0px !important;
            }
            .vc_custom_1553227144918 {
                padding-top: 93px !important;
                padding-bottom: 20px !important;
            }
            .vc_custom_1553226190183 {
                padding-top: 0px !important;
                padding-bottom: 75px !important;
            }
        </style>
        <noscript>
            <style>
                .wpb_animate_when_almost_visible {
                    opacity: 1;
                }
            </style>
        </noscript>

		@if(json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=='rtl')
			<link href="https://fonts.googleapis.com/css2?family=El+Messiri&display=swap" rel="stylesheet">
			<link rel="stylesheet" href="/rtl.css" />
		@endif

		@yield('styles')

		<style media="screen">
		li#menu-item-1267 {
			padding: 17px 0;
		}
		#header-wrap.is-sticky #header-main.h-fixed, #header-wrap.is-sticky-offset #header-main.h-fixed {
		    box-shadow: 0 0 4px #00000030;
		}
		</style>

		<link rel="shortcut icon" type="image/x-icon" href="{{url('/storage/'.config('app.favicon'))}}" />



    </head>

    <body class="@isset($page) {{$page->slug}} @endisset page-template-default page page-id-8 theme-archio woocommerce-no-js reduxon body-default-font heading-default-font visual-composer wpb-js-composer js-comp-ver-6.2.0 vc_responsive elementor-default elementor-kit-1443">
        <div id="page" class="site">
            <div id="ct-loadding" class="ct-loader style3">
                <div class="ct-spinner3">
                    <div class="double-bounce1"></div>
                    <div class="double-bounce2"></div>
                </div>
            </div>

			@include('themes.tameer.inc.header')
			@yield('content')

			@include('themes.tameer.inc.footer')

            <a href="#" class="ct-scroll-top">
                <i class="ti-angle-up"></i>
            </a>

            <div class="hidden-sidebar-overlay"></div>
            <div class="hidden-sidebar">
                <div class="ct-close hidden-sidebar-close"></div>
                <div class="hidden-sidebar-inner">
                    <section id="ct_recent_posts-3" class="widget widget_ct_recent_posts">
                        <div class="widget-content">
                            <h2 class="widget-title">Recent Posts</h2>
                            <div class="posts-list">
                                <div class="entry-brief">
                                    <div class="entry-media">
                                        <a href="2018/10/we-are-opening-new-office/index9ed2.html?lang=en"><img src="wp-content/uploads/2018/10/archio1-150x150.jpg" alt="We are opening new office" /></a>
                                    </div>
                                    <div class="entry-content">
                                        <h4 class="entry-title"><a href="2018/10/we-are-opening-new-office/index9ed2.html?lang=en" title="We are opening new office">We are opening new office</a></h4>
                                        <ul class="entry-meta">
                                            <li class="item-date"><i class="fa fa-calendar"></i>18 October 2018</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="entry-brief">
                                    <div class="entry-media">
                                        <a href="2018/08/job-opportunity-in-tameer/index9ed2.html?lang=en"><img src="wp-content/uploads/2020/05/site-tameer-3-1-scaled-150x150.jpg" alt="Job opportunity in Tameer" /></a>
                                    </div>
                                    <div class="entry-content">
                                        <h4 class="entry-title"><a href="2018/08/job-opportunity-in-tameer/index9ed2.html?lang=en" title="Job opportunity in Tameer">Job opportunity in Tameer</a></h4>
                                        <ul class="entry-meta">
                                            <li class="item-date"><i class="fa fa-calendar"></i>18 August 2018</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="entry-brief">
                                    <div class="entry-media">
                                        <a href="2018/07/we-want-to-hire-someone-for-job/index9ed2.html?lang=en"><img src="wp-content/uploads/2018/10/archio3-150x150.jpg" alt="We want to hire someone for job" /></a>
                                    </div>
                                    <div class="entry-content">
                                        <h4 class="entry-title"><a href="2018/07/we-want-to-hire-someone-for-job/index9ed2.html?lang=en" title="We want to hire someone for job">We want to hire someone for job</a></h4>
                                        <ul class="entry-meta">
                                            <li class="item-date"><i class="fa fa-calendar"></i>18 July 2018</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    <div class="contact-info widget">
                        <h3 class="footer-widget-title widget-title">Contact Us</h3>
                        <ul class="ct-contact-info-inner style1">
                            <li>
                                <i class="fa fa-envelope"></i>
                                <span>info@example.com</span>
                            </li>
                            <li>
                                <i class="fa fa-home"></i>
                                <span>6701 Democracy Blvd, Suite 300, USA</span>
                            </li>
                        </ul>
                    </div>
                    <section id="cs_social_widget-1" class="widget widget_cs_social_widget">
                        <div class="widget-content">
                            <h2 class="widget-title">Follow Us</h2>
                            <ul class="ct-social">
                                <li>
                                    <a class="hover-effect social-facebook" target="_blank" href="#"><i class="fa fa-facebook"></i><span>Facebook</span></a>
                                </li>
                                <li>
                                    <a class="hover-effect social-twitter" target="_blank" href="#"><i class="fa fa-twitter"></i><span>Twitter</span></a>
                                </li>
                                <li>
                                    <a class="hover-effect social-linkedin" target="_blank" href="#"><i class="fa fa-linkedin"></i><span>Linkedin</span></a>
                                </li>
                                <li>
                                    <a class="hover-effect social-pinterest" target="_blank" href="#"><i class="fa fa-pinterest"></i><span>Pinterest</span></a>
                                </li>
                            </ul>
                        </div>
                    </section>
                </div>
            </div>
        </div>
        <!-- #page -->

        <link rel="stylesheet" property="stylesheet" id="rs-icon-set-fa-icon-css" href="wp-content/plugins/revslider/public/assets/fonts/font-awesome/css/font-awesome.css" type="text/css" media="all" />
        <link href="https://fonts.googleapis.com/css?family=Roboto:400%7CPoppins:600%2C700%7CMuli:400%2C600%7COpen+Sans:400" rel="stylesheet" property="stylesheet" media="all" type="text/css" />

        <script type="text/javascript">
            var c = document.body.className;
            c = c.replace(/woocommerce-no-js/, "woocommerce-js");
            document.body.className = c;
        </script>
        <script type="text/javascript">
            if (typeof revslider_showDoubleJqueryError === "undefined") {
                function revslider_showDoubleJqueryError(sliderID) {
                    var err = "<div class='rs_error_message_box'>";
                    err += "<div class='rs_error_message_oops'>Oops...</div>";
                    err += "<div class='rs_error_message_content'>";
                    err += "You have some jquery.js library include that comes after the Slider Revolution files js inclusion.<br>";
                    err += "To fix this, you can:<br>&nbsp;&nbsp;&nbsp; 1. Set 'Module General Options' -> 'Advanced' -> 'jQuery & OutPut Filters' -> 'Put JS to Body' to on";
                    err += "<br>&nbsp;&nbsp;&nbsp; 2. Find the double jQuery.js inclusion and remove it";
                    err += "</div>";
                    err += "</div>";
                    jQuery(sliderID).show().html(err);
                }
            }
        </script>
        <link rel="stylesheet" id="inline-style-css" href="wp-content/themes/archio/assets/css/inline-style5697.css?ver=5.5.3" type="text/css" media="all" />
        <style id="inline-style-inline-css" type="text/css">
            @media screen and (min-width: 1200px) {
                #ct-space-5f9e24219c545 .ct-space {
                    height: 139px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e24219c545 .ct-space {
                    height: 139px;
                }
            }
            @media screen and (max-width: 767px) {
                #ct-space-5f9e24219c545 .ct-space {
                    height: 65px;
                }
            }

            @media (min-width: 991px) and (max-width: 1200px) {
                #ct-heading .ct-heading-tag {
                    font-size: 40px !important;
                    line-height: 50px !important;
                }
            }

            @media (min-width: 768px) and (max-width: 991px) {
                #ct-heading .ct-heading-tag {
                    font-size: 36px !important;
                    line-height: 45px !important;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-heading .ct-heading-tag {
                    font-size: 30px !important;
                    line-height: 38px !important;
                }
            }

            @media (min-width: 991px) and (max-width: 1200px) {
                #ct-heading-2 .ct-heading-tag {
                    font-size: 24px !important;
                    line-height: 30px !important;
                }
            }

            @media (min-width: 768px) and (max-width: 991px) {
                #ct-heading-2 .ct-heading-tag {
                    font-size: 24px !important;
                    line-height: 30px !important;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-heading-2 .ct-heading-tag {
                    font-size: 24px !important;
                    line-height: 30px !important;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a4e50 .ct-space {
                    height: 40px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a4e50 .ct-space {
                    height: 40px;
                }
            }
            @media screen and (max-width: 767px) {
                #ct-space-5f9e2421a4e50 .ct-space {
                    height: 65px;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a59f4 .ct-space {
                    height: 66px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a59f4 .ct-space {
                    height: 66px;
                }
            }
            @media (min-width: 768px) and (max-width: 991px) {
                #ct-space-5f9e2421a59f4 .ct-space {
                    height: 66px;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a61f8 .ct-space {
                    height: 76px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a61f8 .ct-space {
                    height: 76px;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a6be7 .ct-space {
                    height: 76px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a6be7 .ct-space {
                    height: 76px;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-space-5f9e2421a712a .ct-space {
                    height: 40px;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a7916 .ct-space {
                    height: 62px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a7916 .ct-space {
                    height: 62px;
                }
            }
            @media (min-width: 768px) and (max-width: 991px) {
                #ct-space-5f9e2421a7916 .ct-space {
                    height: 62px;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-space-5f9e2421a873f .ct-space {
                    height: 60px;
                }
            }

            @media (min-width: 991px) and (max-width: 1200px) {
                #ct-heading-3 .ct-heading-tag {
                    font-size: 40px !important;
                    line-height: 50px !important;
                }
            }

            @media (min-width: 768px) and (max-width: 991px) {
                #ct-heading-3 .ct-heading-tag {
                    font-size: 36px !important;
                    line-height: 45px !important;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-heading-3 .ct-heading-tag {
                    font-size: 30px !important;
                    line-height: 38px !important;
                }
            }

            @media screen and (min-width: 1200px) {
                #ct-space-5f9e2421a8dcc .ct-space {
                    height: 132px;
                }
            }
            @media (min-width: 992px) and (max-width: 1991px) {
                #ct-space-5f9e2421a8dcc .ct-space {
                    height: 132px;
                }
            }
            @media (min-width: 768px) and (max-width: 991px) {
                #ct-space-5f9e2421a8dcc .ct-space {
                    height: 132px;
                }
            }
            @media screen and (max-width: 767px) {
                #ct-space-5f9e2421a8dcc .ct-space {
                    height: 65px;
                }
            }

            @media (min-width: 991px) and (max-width: 1200px) {
                #ct-heading-4 .ct-heading-tag {
                    font-size: 40px !important;
                    line-height: 50px !important;
                }
            }

            @media (min-width: 768px) and (max-width: 991px) {
                #ct-heading-4 .ct-heading-tag {
                    font-size: 36px !important;
                    line-height: 45px !important;
                }
            }

            @media screen and (max-width: 767px) {
                #ct-heading-4 .ct-heading-tag {
                    font-size: 30px !important;
                    line-height: 38px !important;
                }
            }
        </style>
        <link rel="stylesheet" id="vc_animate-css-css" href="wp-content/plugins/js_composer/assets/lib/bower/animate-css/animate.min10df.css?ver=6.2.0" type="text/css" media="all" />
        <script type="text/javascript" id="thickbox-js-extra">
            /* <![CDATA[ */
            var thickboxL10n = {
                next: "Next >",
                prev: "< Prev",
                image: "Image",
                of: "of",
                close: "Close",
                noiframes: "This feature requires inline frames. You have iframes disabled or your browser does not support them.",
                loadingAnimation: "https:\/\/www.tameer-sa.com\/wp-includes\/js\/thickbox\/loadingAnimation.gif",
            };
            /* ]]> */
        </script>
        <script type="text/javascript" src="wp-includes/js/thickbox/thickboxab87.js?ver=3.1-20121105" id="thickbox-js"></script>

        <script type="text/javascript" src="wp-content/plugins/ctcore/assets/js/ct-frontdc98.js?ver=all" id="ct-front-js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/woocommerce/assets/js/js-cookie/js.cookie.min6b25.js?ver=2.1.4" id="js-cookie-js"></script>

        <script type="text/javascript" src="wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min3428.js?ver=4.5.2" id="woocommerce-js"></script>

        <script type="text/javascript" src="wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min3428.js?ver=4.5.2" id="wc-cart-fragments-js"></script>

		<script src="/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/nice-select.mindc98.js?ver=all" id="nice-select-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/enscrolldc98.js?ver=all" id="enscroll-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/match-height-min8a54.js?ver=1.0.0" id="match-height-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/sidebar-scroll-fixed8a54.js?ver=1.0.0" id="archio-sidebar-fixed-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/magnific-popup.min8a54.js?ver=1.0.0" id="magnific-popup-js"></script>
        <script type="text/javascript" id="archio-main-js-extra">
            /* <![CDATA[ */
            var main_data = { ajax_url: "https:\/\/www.tameer-sa.com\/wp-admin\/admin-ajax.php" };
            /* ]]> */
        </script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/main19f6.js?ver=1.0.7" id="archio-main-js"></script>
        <script type="text/javascript" id="newsletter-subscription-js-extra">
            /* <![CDATA[ */
            var newsletter = {
                messages: {
                    email_error: "Email address is not correct",
                    name_error: "Name is required",
                    surname_error: "Last name is required",
                    profile_error: "A mandatory field is not filled in",
                    privacy_error: "You must accept the privacy policy",
                },
                profile_max: "20",
            };
            /* ]]> */
        </script>
        <script type="text/javascript" src="wp-content/plugins/newsletter/subscription/validatef22c.js?ver=6.8.7" id="newsletter-subscription-js"></script>
        <script type="text/javascript" src="wp-includes/js/wp-embed.min5697.js?ver=5.5.3" id="wp-embed-js"></script>
        <script type="text/javascript" src="wp-content/plugins/js_composer/assets/js/dist/js_composer_front.min10df.js?ver=6.2.0" id="wpb_composer_front_js-js"></script>
        <script type="text/javascript" src="wp-content/plugins/ctcore/assets/js/waypoints.min5697.js?ver=5.5.3" id="waypoints-js"></script>
        <script type="text/javascript" src="wp-content/plugins/js_composer/assets/lib/vc_waypoints/vc-waypoints.min10df.js?ver=6.2.0" id="vc_waypoints-js"></script>
        <script type="text/javascript" src="wp-content/plugins/ctcore/assets/js/owl.carousel.min5697.js?ver=5.5.3" id="owl-carousel-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/ct-carousel19f6.js?ver=1.0.7" id="archio-carousel-js"></script>
        <script type="text/javascript" src="wp-content/plugins/js_composer/assets/lib/bower/skrollr/dist/skrollr.min10df.js?ver=6.2.0" id="vc_jquery_skrollr_js-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/counter.min19f6.js?ver=1.0.7" id="archio-counter-lib-js"></script>
        <script type="text/javascript" src="wp-content/themes/archio/assets/js/ct-counter19f6.js?ver=1.0.7" id="archio-counter-js"></script>


		<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js"></script>
		<script type="text/javascript">
		$(function() {
			$(".scroll").click(function() {
				if (location.pathname == this.pathname) {
					var target = $(this.hash);
					if (target) {
						var topPadding = 40,
							speed = 2,
							currentLocation = $(window).scrollTop(),
							targetLocation = target.offset().top - topPadding,
							distance = Math.abs(currentLocation - targetLocation),
							time = distance / speed;
						$('html,body').animate({
							scrollTop: targetLocation
						}, time, 'easeOutCubic');
						return false;
					}
				}
			});
			});
		</script>
		@yield('scripts')

		<script type="text/javascript" src="/plugins/afrodien/js/app.js"></script>

    </body>

</html>
