@extends('themes.tameer.app')

@section('content')

	<div id="pagetitle" class="page-title bg-overlay">
	    <div class="container">
	        <div class="page-title-inner" style="opacity: 1;">
	            <h1 class="page-title">Project 3</h1>
	            <ul class="ct-breadcrumb">
	                <li><a class="breadcrumb-entry" href="https://www.tameer-sa.com/">الرئيسية</a></li>
	                <li><a class="breadcrumb-entry" href="https://www.tameer-sa.com/portfolio/">Portfolio</a></li>
	                <li><span class="breadcrumb-entry">Project 3</span></li>
	            </ul>
	        </div>
	    </div>
	    <div class="page-title-social">
	        <a href="#" target="_blank"><i class="fa fa-facebook"></i></a><a href="#" target="_blank"><i class="fa fa-twitter"></i></a><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a>
	    </div>
	</div>


	<!-- ===== Start of Login - Register Section ===== -->
	<section id="login">
	    <div class="container">
	        <div class="row">
		        <div class="col-md-6 offset-md-3 col-md-offset-3 col-xs-12">

		            <!-- Start of Login Box -->
		            <div class="login-box">

		                <!-- Start of Login Form -->
		                <form action="{{route('login')}}" method="post">

							@csrf

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <label>{{__('Email')}}</label>
		                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}" placeholder="{{__('Your Email')}}" required autocomplete="email" autofocus />
								@error('email')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <label>{{__('Password')}}</label>
		                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="{{__('Your Password')}}" required autocomplete="current-password" />
								@error('password')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
		                    </div>

		                    <!-- Form Group -->
		                    <div class="form-group">
		                        <div class="row">
		                            <div class="col-6 text-as-lang">
		                                <input id="remember-me2" type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }} />
		                                <label for="remember-me2">{{__('Remember me?')}}</label>
		                            </div>
									<div class="col-6 text-not-as-lang">
				                        <button class="btn btn-success btn-effect" type="submit" name="login">{{__('login')}}</button>
				                    </div>
		                        </div>
		                    </div>

							@if (session('message'))
								<div class="alert alert-danger">{{ session('message') }}</div>
							@endif

							<div class="text-as-lang">
								<a href="{{ route('password.request')}}">- {{__('Forgot password?')}}</a>
							</div>

							<div class="fb-login-button" data-size="large" data-button-type="login_with" data-layout="default" data-auto-logout-link="false" data-use-continue-as="true" data-width=""></div>	                </form>
		                <!-- End of Login Form -->
		            </div>
		            <!-- End of Login Box -->

		        </div>
	        </div>
	    </div>
	</section>
	<!-- ===== End of Login - Register Section ===== -->
@endsection
