@extends('themes.tameer.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
					<h2>{{$page->title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
				<div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
				</div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Login - Register Section ===== -->
	<section id="login">
	    <div class="container">
			<div class="row">
		        <div class="col-md-6 col-md-offset-3 offset-md-3 col-xs-12">

		            <!-- Start of Login Box -->
		            <div class="login-box">

		                <div class="login-title">
		                    <h4>{{ __('Verify Your Email Address') }}</h4>
		                </div>

						<form class="d-inline" method="POST" action="{{ route('verification.resend' , []) }}">
							@csrf

							@if (session('resent'))
								<div class="alert alert-success" role="alert">
									{{ __('A fresh verification link has been sent to your email address.') }}
								</div>
							@endif

							<div class="">
								{{ __('Before proceeding, please check your email for a verification link.') }}
								{{ __('If you did not receive the email') }}, click the below button to request	another.
							</div>


							<br>
							<br>

							<div class="form-group text-center">
		                        <button type="submit" name="verify" class="btn btn-blue btn-effect">{{ __('click here to request another') }}</button>
		                    </div>

						</form>

		                <!-- End of Login Form -->
		            </div>
		            <!-- End of Login Box -->

		        </div>
	        </div>
	    </div>
	</section>
	<!-- ===== End of Login - Register Section ===== -->
@endsection
