<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

$slug = '[\x{0600}-\x{06FF}A-Za-z0-9-]+';
Route::pattern('post_slug', $slug);
Route::pattern('page_slug', $slug);
Route::pattern('category_slug', $slug);
Route::pattern('product_slug', $slug);
Route::pattern('tag_slug', $slug);

Route::pattern('term', '[\x{0600}-\x{06FF}A-Za-z0-9- ]+');

Route::pattern('token', '[A-Za-z0-9-]+');
Route::pattern('uuid', '[A-Za-z0-9-]+');
Route::pattern('id', '[0-9-]+');
Route::pattern('record_id', '[0-9-]+');
Route::pattern('system_id', '[0-9-]+');
Route::pattern('form_id', '[0-9-]+');


Route::get('aaaaaa','Dashboard\MediaController@thumbnail')->name('.index');


Route::group([
	'prefix' => Afrodien::setLocale()
],function () {

    Route::group([
		'prefix'     => 'customer',
		'as'         => 'customer',
		'middleware' => ['auth','verified']
	],function(){

        Route::get('','Customer\HomeController@index')->name('.index');

        Route::group(['prefix'=>'profile','as'=>'.profile'],function(){

            Route::get('','Customer\ProfileController@edit')->name('.index');
            Route::get('edit','Customer\ProfileController@edit')->name('.edit');
			Route::get('change-password','Customer\ProfileController@viewChangePassword')->name('.change-password');

			Route::post('update','Customer\ProfileController@update')->name('.update');
            Route::post('update-password','Customer\ProfileController@updatePassword')->name('.update-password');

        });

        Route::group(['prefix'=>'invoices','as'=>'.invoices'],function (){
            Route::get('','Customer\InvoiceController@index')->name('.index');
            Route::get('view/{uuid}','Customer\InvoiceController@view')->name('.view');
        });

        Route::group(['prefix'=>'products','as'=>'.products'],function (){
            Route::get('','Customer\ProductController@index')->name('.index');
            Route::get('view/{uuid}','Customer\ProductController@view')->name('.view');
        });

		Route::group(['prefix'=>'surveys','as'=>'.surveys'],function (){
			Route::get('','Customer\SurveyController@index')->name('.index');
			Route::get('view/{id}','Customer\SurveyController@view')->name('.view');
			Route::post('submit/{id}','Customer\SurveyController@submit')->name('.submit');
		});

        Route::group(['prefix'=>'tickets','as'=>'.tickets'],function (){

            Route::get('','Customer\TicketController@index')->name('.index');
            Route::get('create','Customer\TicketController@create')->name('.create');
            Route::get('view/{uuid}','Customer\TicketController@view')->name('.view');
			Route::get('close/{uuid}','Customer\TicketController@close')->name('.close');
			Route::get('report/{id}','Customer\TicketController@reporting')->name('.reporting');

			Route::post('store','Customer\TicketController@store')->name('.store');
            Route::post('reply','Customer\TicketController@reply')->name('.reply');
            Route::post('report/{id}','Customer\TicketController@submitReport')->name('.submit-reporting');
            Route::post('rating/{uuid}/','Customer\TicketController@rating')->name('.rating');

        });

    });

	/* ********* Dashboard Route ********** */
    Route::group([
        'prefix'     => 'dashboard',
        'as'         => 'dashboard',
        'middleware' => ['auth','can:dashboard-access','verified']
    ], function () {

		Route::get('', ['as' => '.index', 'uses' => 'Dashboard\DashboardController@index']);

		Route::group([
			'prefix' => 'profile',
			'as'     => '.profile'
		], function () {
	        Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\ProfileController@index']);
			Route::get('edit', ['as'=>'.edit', 'uses'=> 'Dashboard\ProfileController@edit']);
			Route::post('update', ['as'=>'.update', 'uses'=> 'Dashboard\ProfileController@update']);
			Route::get('change-password', ['as'=>'.change-password', 'uses'=> 'Dashboard\ProfileController@changePpassword']);
			Route::post('update-password', ['as'=>'.update-password', 'uses'=> 'Dashboard\ProfileController@updatePassword']);
		});

		Route::group([
			'prefix' => 'surveys',
			'as'     => '.surveys'
		], function () {

			Route::get('reports/{id}', ['as' => '.reports', 'uses'=> 'Dashboard\Surveys\SurveyController@reports']);
			Route::post('submission/delete', ['as' => '.submission.delete', 'uses'=> 'Dashboard\Surveys\SurveyController@delete']);


		});

		Route::group([
			'prefix' => 'tools',
			'as'     => '.tools'
		], function () {
			Route::get('forms', ['as' => '.forms', 'uses'=> 'Dashboard\Tools\VirtualFormController@index']);
			Route::get('forms/{form_id}', ['as' => '.forms.list', 'uses'=> 'Dashboard\Tools\VirtualFormController@list']);
			Route::get('forms/{form_id}/{record_id}', ['as'=>'.forms.view', 'uses'=> 'Dashboard\Tools\VirtualFormController@view']);
			Route::post('forms/data/{form_id}', ['as'=>'.forms.data', 'uses'=> 'Dashboard\Tools\VirtualFormController@data']);
			Route::post('forms/delete/{form_id}', ['as'=>'.forms.delete', 'uses'=> 'Dashboard\Tools\VirtualFormController@delete']);
		});


		Route::group([
			'prefix' => 'developers',
			'as'     => '.developers'
		], function () {
	        Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\Developers\DevelopersController@index']);


			Route::group([
				'prefix' => 'system-builder',
				'as' => '.system-builder'
			],function () {
				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Developers\SystemBuilderController@index']);
				Route::get('create', ['as'=>'.create', 'uses'=> 'Dashboard\Developers\SystemBuilderController@create']);
				Route::post('store', ['as'=>'.store', 'uses'=> 'Dashboard\Developers\SystemBuilderController@store']);
				Route::get('edit/{system_id}', ['as'=>'.edit', 'uses'=> 'Dashboard\Developers\SystemBuilderController@edit']);
				Route::post('update/{system_id}', ['as'=>'.update', 'uses'=> 'Dashboard\Developers\SystemBuilderController@update']);
				Route::post('delete', ['as'=>'.delete', 'uses'=> 'Dashboard\Developers\SystemBuilderController@delete']);
				Route::post('table-fields', 'Dashboard\Developers\SystemBuilderController@listTableField')->name('.table-fields');
			});

			Route::group([
				'prefix' => 'form-builder',
				'as' => '.form-builder'
			],function () {
				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Developers\FormBuilderController@index']);
				Route::get('create', ['as'=>'.create', 'uses'=> 'Dashboard\Developers\FormBuilderController@create']);
				Route::post('store', ['as'=>'.store', 'uses'=> 'Dashboard\Developers\FormBuilderController@store']);
				Route::get('edit/{form_id}', ['as'=>'.edit', 'uses'=> 'Dashboard\Developers\FormBuilderController@edit']);
				Route::post('update/{form_id}', ['as'=>'.update', 'uses'=> 'Dashboard\Developers\FormBuilderController@update']);
				Route::post('delete', ['as'=>'.delete', 'uses'=> 'Dashboard\Developers\FormBuilderController@delete']);
				Route::post('table-fields', 'Dashboard\Developers\FormBuilderController@listTableField')->name('.table-fields');
			});

			Route::group([
				'prefix' => 'api-builder',
				'as' => '.api-builder'
			],function () {
				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Developers\APIController@index']);
				Route::get('create', ['as'=>'.create', 'uses'=> 'Dashboard\Developers\APIController@create']);
				Route::post('store', ['as'=>'.store', 'uses'=> 'Dashboard\Developers\APIController@store']);
				Route::get('edit/{system_id}', ['as'=>'.edit', 'uses'=> 'Dashboard\Developers\APIController@edit']);
				Route::post('update/{system_id}', ['as'=>'.update', 'uses'=> 'Dashboard\Developers\APIController@update']);
				Route::post('delete', ['as'=>'.delete', 'uses'=> 'Dashboard\Developers\APIController@delete']);
				Route::post('table-fields', 'Dashboard\Developers\APIController@listTableField')->name('.table-fields');
			});



		});

		Route::group([
			'prefix' => 'sales',
			'as'     => '.sales'
		], function () {

			Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\Sales\SaleController@index']);

			Route::group([
				'prefix' => 'invoices',
				'as' => '.invoices'
			], function () {

				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Sales\InvoiceController@index']);

			});

			Route::group([
				'prefix' => 'orders',
				'as' => '.orders'
			], function () {

				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Sales\OrderController@index']);

			});

			Route::group([
				'prefix' => 'transactions',
				'as' => '.transactions'
			], function () {

				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Sales\TransactionController@index']);

			});

		});


		Route::group([
			'prefix' => 'support',
			'as' => '.support'
		], function () {

			Route::get('', ['as'=>'.index', 'uses'=> 'SupportController@index']);

			Route::get('reported-message', ['as'=>'.reported-message', 'uses'=> 'Dashboard\Support\TicketsController@listReportedMessages']);

			Route::group([
				'prefix' => 'tickets',
				'as' => '.tickets'
			], function () {
				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\Support\TicketsController@index']);
				Route::get('create', ['as'=>'.create', 'uses'=> 'Dashboard\Support\TicketsController@create']);
				Route::get('view/{id}', ['as'=>'.view', 'uses'=> 'Dashboard\Support\TicketsController@view']);
				Route::post('store', ['as'=>'.store', 'uses'=> 'Dashboard\Support\TicketsController@store']);
				Route::post('reply', ['as'=>'.reply', 'uses'=> 'Dashboard\Support\TicketsController@reply']);
				Route::post('delete', ['as'=>'.delete', 'uses'=> 'Dashboard\Support\TicketsController@delete']);
				Route::post('close', ['as'=>'.close', 'uses'=> 'Dashboard\Support\TicketsController@close']);
			});


		});





		Route::group([
			'prefix' => 'configuration',
			'as' => '.configuration',
			'middleware' => ['password.confirm']
		], function () {

			Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\ConfigurationController@index']);
			Route::get('main-nav', ['as'=>'.main-nav', 'uses'=> 'Dashboard\ConfigurationController@mainNav']);
			Route::get('ads-manager', ['as'=>'.ads-manager', 'uses'=> 'Dashboard\ConfigurationController@adsManager']);
			Route::get('social-media', ['as'=>'.social-media', 'uses'=> 'Dashboard\ConfigurationController@socialMedia']);
			Route::get('mail-setup', ['as'=>'.mail-setup', 'uses'=> 'Dashboard\ConfigurationController@mailSetup']);
			Route::get('email-templates', ['as'=>'.email-templates', 'uses'=> 'Dashboard\ConfigurationController@emailTemplates']);
			Route::get('html-code', ['as'=>'.html-code', 'uses'=> 'Dashboard\ConfigurationController@htmlCode']);
			Route::get('contact-info', ['as'=>'.contact-info', 'uses'=> 'Dashboard\ConfigurationController@contactInfo']);
			Route::get('cookie-notification', ['as'=>'.cookie-notification', 'uses'=> 'Dashboard\ConfigurationController@cookieNotification']);

			Route::post('update', ['as'=>'.update', 'uses'=> 'Dashboard\ConfigurationController@update']);

			Route::group([
				'prefix' => 'languages',
				'as' => '.languages',
				'middleware' => ['password.confirm']
			], function () {

				Route::get('', ['as'=>'', 'uses'=> 'Dashboard\LanguageController@index']);
				Route::post('update', ['as'=>'.update', 'uses'=> 'Dashboard\LanguageController@update']);
				Route::post('store', ['as'=>'.store', 'uses'=> 'Dashboard\LanguageController@store']);

			});

		});

		Route::group([
			'prefix' => 'push-notification',
			'as' => '.push-notification'
		],function () {
			Route::get('', 'Dashboard\PushNotificationController@index')->name('.index');
			Route::post('push', 'Dashboard\PushNotificationController@send')->name('.push');
			Route::post('upate-fcm-key', 'Dashboard\PushNotificationController@UpdateFcmKey')->name('.update-fcm-key');
		});

		Route::group([
			'prefix' => 'newsletter',
			'as' => '.newsletter'
		],function () {
			Route::get('', 'Dashboard\NewsLetterController@index')->name('.index');
			Route::post('send-email', 'Dashboard\NewsLetterController@send')->name('.send-email');
		});


		Route::group([
			'prefix' => 'notifications',
			'as' => '.notifications'
		],function () {
			Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\NotificationController@index']);
	        Route::get('{uuid}', ['as'=>'.view', 'uses'=> 'Dashboard\NotificationController@view']);

		});

		Route::group([
			'prefix' => 'media',
			'as' => '.media'
		],function () {
	        Route::get('', 'Dashboard\MediaController@uploadForm')->name('.index');
	        Route::post('upload', 'Dashboard\MediaController@uploadSubmit')->name('.upload');
	        Route::post('update', 'Dashboard\MediaController@updateMedia')->name('.update');
	        Route::post('load-more', 'Dashboard\MediaController@loadMore')->name('.load-more');
		});


		Route::group([
			'prefix' => 'search',
			'as' => '.search'
		],function () {
	        Route::get('', ['as'=>'.index', 'uses'=> 'Dashboard\SearchController@index']);
	        Route::get('{term}', ['as'=>'.results', 'uses'=> 'Dashboard\SearchController@index']);
		});


        Route::post('feedback', 'Dashboard\FeedbackController@send')->name('.feedback');

        Route::post('users/list', 'Dashboard\UserController@list')->name('.users.list');




		/* ********* Dashboard Dynamic Pages ********** */
        Route::get('{page_slug}', ['as'=>'.virtual-system.index','uses'=>'Dashboard\VirtualSystemController@index']);
        Route::get('{page_slug}/create/', ['as'=>'.virtual-system.create','uses'=>'Dashboard\VirtualSystemController@create']);
        Route::get('{page_slug}/edit/{record_id}', ['as'=>'.virtual-system.edit','uses'=>'Dashboard\VirtualSystemController@edit']);
		Route::post('{page_slug}/create', ['as'=>'.virtual-system.store', 'uses'=> 'Dashboard\VirtualSystemController@store']);
        Route::post('{page_slug}/data', ['as'=>'.virtual-system.data', 'uses'=> 'Dashboard\VirtualSystemController@data']);
        Route::post('{page_slug}/edit/{record_id}', ['as'=>'.virtual-system.update', 'uses'=> 'Dashboard\VirtualSystemController@update']);
        Route::post('{page_slug}/delete', ['as'=>'.virtual-system.delete', 'uses'=> 'Dashboard\VirtualSystemController@delete']);
		Route::post('virtual/based-on', ['as'=>'.virtual-system.based-on', 'uses'=> 'Dashboard\VirtualSystemController@basedOn']);

    });


	Auth::routes(['verify' => true]);


	Route::group([
		'prefix' => 'sitemap',
		'as' => 'sitemap'
	],function () {
		Route::get('index.xml', 'Sitemap\SitemapController@index')->name('.index');
		Route::get('pages.xml', 'Sitemap\SitemapController@pages')->name('.pages');
		Route::get('posts.xml', 'Sitemap\SitemapController@posts')->name('.posts');
		Route::get('categories.xml', 'Sitemap\SitemapController@categories')->name('.categories');
		Route::get('tags.xml', 'Sitemap\SitemapController@tags')->name('.tags');
	});


	Route::group([
		'as' => 'frontend'
	],function () {
		Route::get('download-files', ['as'=>'.download-files', 'uses'=> 'FrontEnd\PageController@download']);

		Route::get('', 'FrontEnd\PageController@index')->name('.index');
		Route::get('{page_slug}', 'FrontEnd\PageController@index')->name('.page');
		Route::get('search/{term}', 'FrontEnd\PageController@viewSearch')->name('.search');


		Route::post('contact', ['as'=>'.contact.submit', 'uses'=> 'FrontEnd\ContactController@submit']);

		Route::post('virtual-form/submit', 'FrontEnd\VirtualFormController@submit')->name('.virtual-form.submit');

		Route::post('ajax/save-token', 'FrontEnd\PushNotificationController@saveToken')->name('.push-notification.saveToken');

		Route::get('notifications/{uuid}', 'FrontEnd\PushNotificationController@open')->name('.push-notification.open');

		Route::post('newsletter', ['as'=>'.newsletter.submit', 'uses'=> 'FrontEnd\NewsLetterController@submit']);
		Route::get('newsletter/verify/{token}', ['as'=>'newsletter.verify', 'uses'=> 'FrontEnd\NewsLetterController@verify']);

		Route::get('blog', 'FrontEnd\BlogController@index')->name('.blog');
	    Route::get('{category_slug}', 'FrontEnd\BlogController@viewCategory')->name('.blog.category');
		Route::get('tags/{tag_slug}', 'FrontEnd\BlogController@viewTag')->name('.blog.tag');
		Route::get('{category_slug}/{post_slug}', 'FrontEnd\PageController@postSlug')->name('.blog.post');
		Route::post('comment', ['as'=>'.blog.comments.submit', 'uses'=> 'FrontEnd\CommentController@submit']);

		Route::get('store', 'FrontEnd\StoreController@index')->name('.store');
		Route::get('{category_slug}/{product_slug}', 'FrontEnd\PageController@postSlug')->name('.store.product');

		Route::get('services', 'FrontEnd\ServiceController@index')->name('.services.index');
		Route::get('services/{slug}', 'FrontEnd\PageController@postSlug')->name('.services.view');

		Route::get('albums', 'FrontEnd\GalleryController@index')->name('.albums.index');
		Route::get('albums/{category}', 'FrontEnd\GalleryController@viewCategory')->name('.albums.categories.view');
		Route::get('albums/{category}/{slug}', 'FrontEnd\GalleryController@view')->name('.albums.view');

	});

});
